package com.namasoft.modules.commonbasic.contracts.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTODetailLineWithAdditional;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxConfiguration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOLegalEntityTax extends DTODetailLineWithAdditional implements Serializable
{
	private BigDecimal tax1;
	private BigDecimal tax2;
	private Boolean excludeTax1FromCost;
	private Boolean excludeTax2FromCost;
	private DTOTaxConfiguration taxConfiguration;
	private Date effectiveFrom;
	private Date effectiveTo;
	private EntityReferenceData entityTypeList;
	private EntityReferenceData legalEntity;
	private String entityType;
	private String revisionId;
	public BigDecimal getTax1()
	{
		return tax1;
	}

	public BigDecimal getTax2()
	{
		return tax2;
	}

	public Boolean getExcludeTax1FromCost()
	{
		return excludeTax1FromCost;
	}

	public Boolean getExcludeTax2FromCost()
	{
		return excludeTax2FromCost;
	}

	public DTOTaxConfiguration getTaxConfiguration()
	{
		return taxConfiguration;
	}

	public Date getEffectiveFrom()
	{
		return effectiveFrom;
	}

	public Date getEffectiveTo()
	{
		return effectiveTo;
	}

	public EntityReferenceData getEntityTypeList()
	{
		return entityTypeList;
	}

	public EntityReferenceData getLegalEntity()
	{
		return legalEntity;
	}

	public String getEntityType()
	{
		return entityType;
	}

	public String getRevisionId()
	{
		return revisionId;
	}

	public void setEffectiveFrom(Date effectiveFrom)
	{
		this.effectiveFrom = effectiveFrom;
	}

	public void setEffectiveTo(Date effectiveTo)
	{
		this.effectiveTo = effectiveTo;
	}

	public void setEntityType(String entityType)
	{
		this.entityType = entityType;
	}

	public void setEntityTypeList(EntityReferenceData entityTypeList)
	{
		this.entityTypeList = entityTypeList;
	}

	public void setExcludeTax1FromCost(Boolean excludeTax1FromCost)
	{
		this.excludeTax1FromCost = excludeTax1FromCost;
	}

	public void setExcludeTax2FromCost(Boolean excludeTax2FromCost)
	{
		this.excludeTax2FromCost = excludeTax2FromCost;
	}

	public void setLegalEntity(EntityReferenceData legalEntity)
	{
		this.legalEntity = legalEntity;
	}

	public void setRevisionId(String revisionId)
	{
		this.revisionId = revisionId;
	}

	public void setTax1(BigDecimal tax1)
	{
		this.tax1 = tax1;
	}

	public void setTax2(BigDecimal tax2)
	{
		this.tax2 = tax2;
	}

	public void setTaxConfiguration(DTOTaxConfiguration taxConfiguration)
	{
		this.taxConfiguration = taxConfiguration;
	}

}
