package com.namasoft.modules.commonbasic.contracts.details;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTODetailLineWithAdditional;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOTaxConfigurationCodeSource extends DTODetailLineWithAdditional implements Serializable
{
	private DTOGenericDimensions dimensions;
	private Date fromValueDate;
	private Date toValueDate;
	private EntityReferenceData criteriaDefinition;
	private EntityReferenceData documentBook;
	private EntityReferenceData documentTerm;
	private EntityReferenceData entityTypeList;
	private String forType;
	private String taxCodesType;
	public DTOGenericDimensions getDimensions()
	{
		return dimensions;
	}

	public Date getFromValueDate()
	{
		return fromValueDate;
	}

	public Date getToValueDate()
	{
		return toValueDate;
	}

	public EntityReferenceData getCriteriaDefinition()
	{
		return criteriaDefinition;
	}

	public EntityReferenceData getDocumentBook()
	{
		return documentBook;
	}

	public EntityReferenceData getDocumentTerm()
	{
		return documentTerm;
	}

	public EntityReferenceData getEntityTypeList()
	{
		return entityTypeList;
	}

	public String getForType()
	{
		return forType;
	}

	public String getTaxCodesType()
	{
		return taxCodesType;
	}

	public void setCriteriaDefinition(EntityReferenceData criteriaDefinition)
	{
		this.criteriaDefinition = criteriaDefinition;
	}

	public void setDimensions(DTOGenericDimensions dimensions)
	{
		this.dimensions = dimensions;
	}

	public void setDocumentBook(EntityReferenceData documentBook)
	{
		this.documentBook = documentBook;
	}

	public void setDocumentTerm(EntityReferenceData documentTerm)
	{
		this.documentTerm = documentTerm;
	}

	public void setEntityTypeList(EntityReferenceData entityTypeList)
	{
		this.entityTypeList = entityTypeList;
	}

	public void setForType(String forType)
	{
		this.forType = forType;
	}

	public void setFromValueDate(Date fromValueDate)
	{
		this.fromValueDate = fromValueDate;
	}

	public void setTaxCodesType(String taxCodesType)
	{
		this.taxCodesType = taxCodesType;
	}

	public void setToValueDate(Date toValueDate)
	{
		this.toValueDate = toValueDate;
	}

}
