package com.namasoft.modules.commonbasic.contracts.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.Filter;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.contracts.details.DTOMenuGroup;
import com.namasoft.modules.commonbasic.contracts.details.DTOMenuItem;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOMenuDefinition extends GeneratedDTOMenuDefinition implements Serializable
{
	public List<DTOMenuGroup> roots()
	{
		return CollectionsUtility.filter(getGroups(), new Filter<DTOMenuGroup>()
		{
			@Override
			public boolean include(DTOMenuGroup object)
			{
				return object.getRootGroup();
			}
		});
	}

	public List<DTOMenuGroup> childGroups(final String groupCode)
	{
		return CollectionsUtility.filter(getGroups(), new Filter<DTOMenuGroup>()
		{
			@Override
			public boolean include(DTOMenuGroup object)
			{
				return ObjectChecker.areEqual(object.getParentCode(), groupCode);
			}
		});
	}

	public List<DTOMenuItem> childItems(List<DTOMenuGroup> groups)
	{
		List<DTOMenuItem> items = new ArrayList<DTOMenuItem>();
		for (DTOMenuGroup group : groups)
		{
			items.addAll(childItems(group.getCode()));
		}
		return items;
	}

	public List<DTOMenuItem> childItems(final String groupCode)
	{
		return CollectionsUtility.filter(getItems(), new Filter<DTOMenuItem>()
		{
			@Override
			public boolean include(DTOMenuItem object)
			{
				return ObjectChecker.areEqual(object.getGroupCode(), groupCode);
			}
		});
	}

	public DTOMenuGroup groupWithId(String code)
	{
		for (DTOMenuGroup group : getGroups())
		{
			if (ObjectChecker.areEqual(code, group.getCode()))
				return group;
		}
		return null;
	}

	public DTOMenuItem getMenuItemByIdOrCode(String src)
	{
		if (ObjectChecker.isEmptyOrNull(src))
			return null;
		for (DTOMenuItem line : getItems())
		{
			if (ObjectChecker.isAnyEqualToFirst(src, line.getId(), line.getCode()))
				return line;
		}
		return null;
	}
}
