package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOAccountsBagCurrencyLine;
import com.namasoft.modules.commonbasic.contracts.details.DTOAccountsBagLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSubsidiaryOwner;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOAccountsBag extends MasterFileDTO implements Serializable
{
	private Boolean doNotCopyBagAccounts;
	private Boolean ignoreSubsidiaryAccounts;
	private DTOSubsidiaryOwner subsidiaryAccounts;
	private List<DTOAccountsBagCurrencyLine> currencyAccountLines = new ArrayList<DTOAccountsBagCurrencyLine>();
	private List<DTOAccountsBagLine> details = new ArrayList<DTOAccountsBagLine>();
	private String accountsIDs;
	private String subsidiaryType;
	public Boolean getDoNotCopyBagAccounts()
	{
		return doNotCopyBagAccounts;
	}

	public Boolean getIgnoreSubsidiaryAccounts()
	{
		return ignoreSubsidiaryAccounts;
	}

	public DTOSubsidiaryOwner getSubsidiaryAccounts()
	{
		return subsidiaryAccounts;
	}

	public List<DTOAccountsBagCurrencyLine> getCurrencyAccountLines()
	{
		return currencyAccountLines;
	}

	public List<DTOAccountsBagLine> getDetails()
	{
		return details;
	}

	public String getAccountsIDs()
	{
		return accountsIDs;
	}

	public String getSubsidiaryType()
	{
		return subsidiaryType;
	}

	public void setAccountsIDs(String accountsIDs)
	{
		this.accountsIDs = accountsIDs;
	}

	public void setCurrencyAccountLines(List<DTOAccountsBagCurrencyLine> currencyAccountLines)
	{
		this.currencyAccountLines = currencyAccountLines;
	}

	public void setDetails(List<DTOAccountsBagLine> details)
	{
		this.details = details;
	}

	public void setDoNotCopyBagAccounts(Boolean doNotCopyBagAccounts)
	{
		this.doNotCopyBagAccounts = doNotCopyBagAccounts;
	}

	public void setIgnoreSubsidiaryAccounts(Boolean ignoreSubsidiaryAccounts)
	{
		this.ignoreSubsidiaryAccounts = ignoreSubsidiaryAccounts;
	}

	public void setSubsidiaryAccounts(DTOSubsidiaryOwner subsidiaryAccounts)
	{
		this.subsidiaryAccounts = subsidiaryAccounts;
	}

	public void setSubsidiaryType(String subsidiaryType)
	{
		this.subsidiaryType = subsidiaryType;
	}

}
