package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOAddress;
import com.namasoft.contracts.common.dtos.DTOContactInfo;
import com.namasoft.contracts.common.dtos.DTOLargeData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOCreditLimits;
import com.namasoft.modules.commonbasic.contracts.details.DTOCustomerContactInfo;
import com.namasoft.modules.commonbasic.contracts.details.DTOCustomerKeywordLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOBankInfo;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOLegalDoc;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSubsidiaryOwner;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxInfo;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOCustomer extends MasterFileDTO implements Serializable
{
	private BigDecimal downPaymentPercentage;
	private BigDecimal limitValue;
	private Boolean activated;
	private Boolean allowCredit;
	private Boolean allowUnlimitedCredit;
	private Boolean b10;
	private Boolean b1;
	private Boolean b2;
	private Boolean b3;
	private Boolean b4;
	private Boolean b5;
	private Boolean b6;
	private Boolean b7;
	private Boolean b8;
	private Boolean b9;
	private Boolean generateContacts;
	private Boolean sameContactAddress;
	private Boolean sameShipingAddress;
	private Boolean usePortal;
	private DTOAddress billingAddress;
	private DTOAddress shippingAddress;
	private DTOBankInfo bankInfo;
	private DTOContactInfo contactInfo;
	private DTOLargeData attachment1;
	private DTOLargeData attachment2;
	private DTOLargeData attachment3;
	private DTOLargeData attachment;
	private DTOLargeData commercialRegAttach;
	private DTOLargeData taxRegAttach;
	private DTOLegalDoc passport;
	private DTOLegalDoc residency;
	private DTOSubsidiaryOwner subsidiaryAccounts;
	private DTOTaxInfo taxInfo;
	private Date birthDate;
	private EntityReferenceData contactsGroup;
	private EntityReferenceData customerCategory;
	private EntityReferenceData customerClass1;
	private EntityReferenceData customerClass2;
	private EntityReferenceData customerClass3;
	private EntityReferenceData customerClass4;
	private EntityReferenceData customerClass5;
	private EntityReferenceData customerClass;
	private EntityReferenceData keywordTemplate;
	private EntityReferenceData leadOrPotential;
	private EntityReferenceData payingCustomer;
	private EntityReferenceData ref10;
	private EntityReferenceData ref11;
	private EntityReferenceData ref12;
	private EntityReferenceData ref6;
	private EntityReferenceData ref7;
	private EntityReferenceData ref8;
	private EntityReferenceData ref9;
	private EntityReferenceData responsibleForCustomer;
	private EntityReferenceData salesMan;
	private EntityReferenceData securityProfile;
	private EntityReferenceData taxPlan;
	private Integer importance;
	private Integer paymentPeriod;
	private List<DTOCreditLimits> creditLimits = new ArrayList<DTOCreditLimits>();
	private List<DTOCustomerContactInfo> contacts = new ArrayList<DTOCustomerContactInfo>();
	private List<DTOCustomerKeywordLine> keywordLines = new ArrayList<DTOCustomerKeywordLine>();
	private String altCode;
	private String cachedSizes;
	private String campaignId;
	private String contactTitle;
	private String defaultUOM;
	private String gender;
	private String maritalStatus;
	private String offlineAppSourceSalesPrice;
	private String portalId;
	private String portalPassword;
	private String priceListDefaultPrice;
	private String remarks2;
	private String userCampaignId;
	public BigDecimal getDownPaymentPercentage()
	{
		return downPaymentPercentage;
	}

	public BigDecimal getLimitValue()
	{
		return limitValue;
	}

	public Boolean getActivated()
	{
		return activated;
	}

	public Boolean getAllowCredit()
	{
		return allowCredit;
	}

	public Boolean getAllowUnlimitedCredit()
	{
		return allowUnlimitedCredit;
	}

	public Boolean getB1()
	{
		return b1;
	}

	public Boolean getB10()
	{
		return b10;
	}

	public Boolean getB2()
	{
		return b2;
	}

	public Boolean getB3()
	{
		return b3;
	}

	public Boolean getB4()
	{
		return b4;
	}

	public Boolean getB5()
	{
		return b5;
	}

	public Boolean getB6()
	{
		return b6;
	}

	public Boolean getB7()
	{
		return b7;
	}

	public Boolean getB8()
	{
		return b8;
	}

	public Boolean getB9()
	{
		return b9;
	}

	public Boolean getGenerateContacts()
	{
		return generateContacts;
	}

	public Boolean getSameContactAddress()
	{
		return sameContactAddress;
	}

	public Boolean getSameShipingAddress()
	{
		return sameShipingAddress;
	}

	public Boolean getUsePortal()
	{
		return usePortal;
	}

	public DTOAddress getBillingAddress()
	{
		return billingAddress;
	}

	public DTOAddress getShippingAddress()
	{
		return shippingAddress;
	}

	public DTOBankInfo getBankInfo()
	{
		return bankInfo;
	}

	public DTOContactInfo getContactInfo()
	{
		return contactInfo;
	}

	public DTOLargeData getAttachment()
	{
		return attachment;
	}

	public DTOLargeData getAttachment1()
	{
		return attachment1;
	}

	public DTOLargeData getAttachment2()
	{
		return attachment2;
	}

	public DTOLargeData getAttachment3()
	{
		return attachment3;
	}

	public DTOLargeData getCommercialRegAttach()
	{
		return commercialRegAttach;
	}

	public DTOLargeData getTaxRegAttach()
	{
		return taxRegAttach;
	}

	public DTOLegalDoc getPassport()
	{
		return passport;
	}

	public DTOLegalDoc getResidency()
	{
		return residency;
	}

	public DTOSubsidiaryOwner getSubsidiaryAccounts()
	{
		return subsidiaryAccounts;
	}

	public DTOTaxInfo getTaxInfo()
	{
		return taxInfo;
	}

	public Date getBirthDate()
	{
		return birthDate;
	}

	public EntityReferenceData getContactsGroup()
	{
		return contactsGroup;
	}

	public EntityReferenceData getCustomerCategory()
	{
		return customerCategory;
	}

	public EntityReferenceData getCustomerClass()
	{
		return customerClass;
	}

	public EntityReferenceData getCustomerClass1()
	{
		return customerClass1;
	}

	public EntityReferenceData getCustomerClass2()
	{
		return customerClass2;
	}

	public EntityReferenceData getCustomerClass3()
	{
		return customerClass3;
	}

	public EntityReferenceData getCustomerClass4()
	{
		return customerClass4;
	}

	public EntityReferenceData getCustomerClass5()
	{
		return customerClass5;
	}

	public EntityReferenceData getKeywordTemplate()
	{
		return keywordTemplate;
	}

	public EntityReferenceData getLeadOrPotential()
	{
		return leadOrPotential;
	}

	public EntityReferenceData getPayingCustomer()
	{
		return payingCustomer;
	}

	public EntityReferenceData getRef10()
	{
		return ref10;
	}

	public EntityReferenceData getRef11()
	{
		return ref11;
	}

	public EntityReferenceData getRef12()
	{
		return ref12;
	}

	public EntityReferenceData getRef6()
	{
		return ref6;
	}

	public EntityReferenceData getRef7()
	{
		return ref7;
	}

	public EntityReferenceData getRef8()
	{
		return ref8;
	}

	public EntityReferenceData getRef9()
	{
		return ref9;
	}

	public EntityReferenceData getResponsibleForCustomer()
	{
		return responsibleForCustomer;
	}

	public EntityReferenceData getSalesMan()
	{
		return salesMan;
	}

	public EntityReferenceData getSecurityProfile()
	{
		return securityProfile;
	}

	public EntityReferenceData getTaxPlan()
	{
		return taxPlan;
	}

	public Integer getImportance()
	{
		return importance;
	}

	public Integer getPaymentPeriod()
	{
		return paymentPeriod;
	}

	public List<DTOCreditLimits> getCreditLimits()
	{
		return creditLimits;
	}

	public List<DTOCustomerContactInfo> getContacts()
	{
		return contacts;
	}

	public List<DTOCustomerKeywordLine> getKeywordLines()
	{
		return keywordLines;
	}

	public String getAltCode()
	{
		return altCode;
	}

	public String getCachedSizes()
	{
		return cachedSizes;
	}

	public String getCampaignId()
	{
		return campaignId;
	}

	public String getContactTitle()
	{
		return contactTitle;
	}

	public String getDefaultUOM()
	{
		return defaultUOM;
	}

	public String getGender()
	{
		return gender;
	}

	public String getMaritalStatus()
	{
		return maritalStatus;
	}

	public String getOfflineAppSourceSalesPrice()
	{
		return offlineAppSourceSalesPrice;
	}

	public String getPortalId()
	{
		return portalId;
	}

	public String getPortalPassword()
	{
		return portalPassword;
	}

	public String getPriceListDefaultPrice()
	{
		return priceListDefaultPrice;
	}

	public String getRemarks2()
	{
		return remarks2;
	}

	public String getUserCampaignId()
	{
		return userCampaignId;
	}

	public void setActivated(Boolean activated)
	{
		this.activated = activated;
	}

	public void setAllowCredit(Boolean allowCredit)
	{
		this.allowCredit = allowCredit;
	}

	public void setAllowUnlimitedCredit(Boolean allowUnlimitedCredit)
	{
		this.allowUnlimitedCredit = allowUnlimitedCredit;
	}

	public void setAltCode(String altCode)
	{
		this.altCode = altCode;
	}

	public void setAttachment(DTOLargeData attachment)
	{
		this.attachment = attachment;
	}

	public void setAttachment1(DTOLargeData attachment1)
	{
		this.attachment1 = attachment1;
	}

	public void setAttachment2(DTOLargeData attachment2)
	{
		this.attachment2 = attachment2;
	}

	public void setAttachment3(DTOLargeData attachment3)
	{
		this.attachment3 = attachment3;
	}

	public void setB1(Boolean b1)
	{
		this.b1 = b1;
	}

	public void setB10(Boolean b10)
	{
		this.b10 = b10;
	}

	public void setB2(Boolean b2)
	{
		this.b2 = b2;
	}

	public void setB3(Boolean b3)
	{
		this.b3 = b3;
	}

	public void setB4(Boolean b4)
	{
		this.b4 = b4;
	}

	public void setB5(Boolean b5)
	{
		this.b5 = b5;
	}

	public void setB6(Boolean b6)
	{
		this.b6 = b6;
	}

	public void setB7(Boolean b7)
	{
		this.b7 = b7;
	}

	public void setB8(Boolean b8)
	{
		this.b8 = b8;
	}

	public void setB9(Boolean b9)
	{
		this.b9 = b9;
	}

	public void setBankInfo(DTOBankInfo bankInfo)
	{
		this.bankInfo = bankInfo;
	}

	public void setBillingAddress(DTOAddress billingAddress)
	{
		this.billingAddress = billingAddress;
	}

	public void setBirthDate(Date birthDate)
	{
		this.birthDate = birthDate;
	}

	public void setCachedSizes(String cachedSizes)
	{
		this.cachedSizes = cachedSizes;
	}

	public void setCampaignId(String campaignId)
	{
		this.campaignId = campaignId;
	}

	public void setCommercialRegAttach(DTOLargeData commercialRegAttach)
	{
		this.commercialRegAttach = commercialRegAttach;
	}

	public void setContactInfo(DTOContactInfo contactInfo)
	{
		this.contactInfo = contactInfo;
	}

	public void setContactTitle(String contactTitle)
	{
		this.contactTitle = contactTitle;
	}

	public void setContacts(List<DTOCustomerContactInfo> contacts)
	{
		this.contacts = contacts;
	}

	public void setContactsGroup(EntityReferenceData contactsGroup)
	{
		this.contactsGroup = contactsGroup;
	}

	public void setCreditLimits(List<DTOCreditLimits> creditLimits)
	{
		this.creditLimits = creditLimits;
	}

	public void setCustomerCategory(EntityReferenceData customerCategory)
	{
		this.customerCategory = customerCategory;
	}

	public void setCustomerClass(EntityReferenceData customerClass)
	{
		this.customerClass = customerClass;
	}

	public void setCustomerClass1(EntityReferenceData customerClass1)
	{
		this.customerClass1 = customerClass1;
	}

	public void setCustomerClass2(EntityReferenceData customerClass2)
	{
		this.customerClass2 = customerClass2;
	}

	public void setCustomerClass3(EntityReferenceData customerClass3)
	{
		this.customerClass3 = customerClass3;
	}

	public void setCustomerClass4(EntityReferenceData customerClass4)
	{
		this.customerClass4 = customerClass4;
	}

	public void setCustomerClass5(EntityReferenceData customerClass5)
	{
		this.customerClass5 = customerClass5;
	}

	public void setDefaultUOM(String defaultUOM)
	{
		this.defaultUOM = defaultUOM;
	}

	public void setDownPaymentPercentage(BigDecimal downPaymentPercentage)
	{
		this.downPaymentPercentage = downPaymentPercentage;
	}

	public void setGender(String gender)
	{
		this.gender = gender;
	}

	public void setGenerateContacts(Boolean generateContacts)
	{
		this.generateContacts = generateContacts;
	}

	public void setImportance(Integer importance)
	{
		this.importance = importance;
	}

	public void setKeywordLines(List<DTOCustomerKeywordLine> keywordLines)
	{
		this.keywordLines = keywordLines;
	}

	public void setKeywordTemplate(EntityReferenceData keywordTemplate)
	{
		this.keywordTemplate = keywordTemplate;
	}

	public void setLeadOrPotential(EntityReferenceData leadOrPotential)
	{
		this.leadOrPotential = leadOrPotential;
	}

	public void setLimitValue(BigDecimal limitValue)
	{
		this.limitValue = limitValue;
	}

	public void setMaritalStatus(String maritalStatus)
	{
		this.maritalStatus = maritalStatus;
	}

	public void setOfflineAppSourceSalesPrice(String offlineAppSourceSalesPrice)
	{
		this.offlineAppSourceSalesPrice = offlineAppSourceSalesPrice;
	}

	public void setPassport(DTOLegalDoc passport)
	{
		this.passport = passport;
	}

	public void setPayingCustomer(EntityReferenceData payingCustomer)
	{
		this.payingCustomer = payingCustomer;
	}

	public void setPaymentPeriod(Integer paymentPeriod)
	{
		this.paymentPeriod = paymentPeriod;
	}

	public void setPortalId(String portalId)
	{
		this.portalId = portalId;
	}

	public void setPortalPassword(String portalPassword)
	{
		this.portalPassword = portalPassword;
	}

	public void setPriceListDefaultPrice(String priceListDefaultPrice)
	{
		this.priceListDefaultPrice = priceListDefaultPrice;
	}

	public void setRef10(EntityReferenceData ref10)
	{
		this.ref10 = ref10;
	}

	public void setRef11(EntityReferenceData ref11)
	{
		this.ref11 = ref11;
	}

	public void setRef12(EntityReferenceData ref12)
	{
		this.ref12 = ref12;
	}

	public void setRef6(EntityReferenceData ref6)
	{
		this.ref6 = ref6;
	}

	public void setRef7(EntityReferenceData ref7)
	{
		this.ref7 = ref7;
	}

	public void setRef8(EntityReferenceData ref8)
	{
		this.ref8 = ref8;
	}

	public void setRef9(EntityReferenceData ref9)
	{
		this.ref9 = ref9;
	}

	public void setRemarks2(String remarks2)
	{
		this.remarks2 = remarks2;
	}

	public void setResidency(DTOLegalDoc residency)
	{
		this.residency = residency;
	}

	public void setResponsibleForCustomer(EntityReferenceData responsibleForCustomer)
	{
		this.responsibleForCustomer = responsibleForCustomer;
	}

	public void setSalesMan(EntityReferenceData salesMan)
	{
		this.salesMan = salesMan;
	}

	public void setSameContactAddress(Boolean sameContactAddress)
	{
		this.sameContactAddress = sameContactAddress;
	}

	public void setSameShipingAddress(Boolean sameShipingAddress)
	{
		this.sameShipingAddress = sameShipingAddress;
	}

	public void setSecurityProfile(EntityReferenceData securityProfile)
	{
		this.securityProfile = securityProfile;
	}

	public void setShippingAddress(DTOAddress shippingAddress)
	{
		this.shippingAddress = shippingAddress;
	}

	public void setSubsidiaryAccounts(DTOSubsidiaryOwner subsidiaryAccounts)
	{
		this.subsidiaryAccounts = subsidiaryAccounts;
	}

	public void setTaxInfo(DTOTaxInfo taxInfo)
	{
		this.taxInfo = taxInfo;
	}

	public void setTaxPlan(EntityReferenceData taxPlan)
	{
		this.taxPlan = taxPlan;
	}

	public void setTaxRegAttach(DTOLargeData taxRegAttach)
	{
		this.taxRegAttach = taxRegAttach;
	}

	public void setUsePortal(Boolean usePortal)
	{
		this.usePortal = usePortal;
	}

	public void setUserCampaignId(String userCampaignId)
	{
		this.userCampaignId = userCampaignId;
	}

}
