package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOACCCustomSecurity;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOActionSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOAllowItemInMenusLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOCustomSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOExtraSecurityFilters;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericActionSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericCustomSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericSecurityFieldAuthority;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericStandardSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOListViewSecurityLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOPageSecurity;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSCCustomSecurity;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOSecurityFieldAuthority;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOStandardSecurityLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOSecurityProfile extends MasterFileDTO implements Serializable
{
	private Boolean allowPDFPrintOnlyForForms;
	private Boolean allowPDFPrintOnlyForReports;
	private Boolean allowPreventedRecordsInInsert;
	private Boolean allowPreventedRecordsInUpdate;
	private Boolean autoFetchUserShift;
	private Boolean autoLogoutWithMaxSessions;
	private Boolean displayPreventedRecords;
	private Boolean doNotDisplayCriticalErrors;
	private Boolean doNotDisplaySystemHelpMsgs;
	private Boolean doNotUseLDAPForLogin;
	private Boolean doNotdispPrevRecInListView;
	private Boolean fullAuthority;
	private Boolean loginFromAppsOnly;
	private Boolean prevUserToRunSameRepMultipleTimes;
	private Boolean restrictAccessToLeads;
	private Boolean viewSystemReports;
	private DTOACCCustomSecurity accCustomSecurity;
	private DTOSCCustomSecurity scCustomSecurity;
	private EntityReferenceData copyEntitiesFromMenu;
	private EntityReferenceData dashBoard;
	private EntityReferenceData defaultMenu;
	private EntityReferenceData usersCounter;
	private Integer maxLoginSessions;
	private Integer maxNumberToRunReport;
	private Integer maxRecordsPerPageForListViews;
	private List<DTOActionSecurityLine> actionLines = new ArrayList<DTOActionSecurityLine>();
	private List<DTOAllowItemInMenusLine> allowDisallowInMenus = new ArrayList<DTOAllowItemInMenusLine>();
	private List<DTOCustomSecurityLine> customLines = new ArrayList<DTOCustomSecurityLine>();
	private List<DTOExtraSecurityFilters> extraFilters = new ArrayList<DTOExtraSecurityFilters>();
	private List<DTOGenericActionSecurityLine> genericActionLines = new ArrayList<DTOGenericActionSecurityLine>();
	private List<DTOGenericCustomSecurityLine> genericCustomLines = new ArrayList<DTOGenericCustomSecurityLine>();
	private List<DTOGenericSecurityFieldAuthority> genericDisabledFields = new ArrayList<DTOGenericSecurityFieldAuthority>();
	private List<DTOGenericStandardSecurityLine> genericStandardLines = new ArrayList<DTOGenericStandardSecurityLine>();
	private List<DTOListViewSecurityLine> listViewSecurityLines = new ArrayList<DTOListViewSecurityLine>();
	private List<DTOPageSecurity> pageSecurity = new ArrayList<DTOPageSecurity>();
	private List<DTOSecurityFieldAuthority> disabledFields = new ArrayList<DTOSecurityFieldAuthority>();
	private List<DTOStandardSecurityLine> standardLines = new ArrayList<DTOStandardSecurityLine>();
	private String allowAccessToAI;
	private String copyEntitiesFromGroup;
	private String defaultLayoutName;
	private String emailUsedWithSendAsEmailWindow;
	public Boolean getAllowPDFPrintOnlyForForms()
	{
		return allowPDFPrintOnlyForForms;
	}

	public Boolean getAllowPDFPrintOnlyForReports()
	{
		return allowPDFPrintOnlyForReports;
	}

	public Boolean getAllowPreventedRecordsInInsert()
	{
		return allowPreventedRecordsInInsert;
	}

	public Boolean getAllowPreventedRecordsInUpdate()
	{
		return allowPreventedRecordsInUpdate;
	}

	public Boolean getAutoFetchUserShift()
	{
		return autoFetchUserShift;
	}

	public Boolean getAutoLogoutWithMaxSessions()
	{
		return autoLogoutWithMaxSessions;
	}

	public Boolean getDisplayPreventedRecords()
	{
		return displayPreventedRecords;
	}

	public Boolean getDoNotDisplayCriticalErrors()
	{
		return doNotDisplayCriticalErrors;
	}

	public Boolean getDoNotDisplaySystemHelpMsgs()
	{
		return doNotDisplaySystemHelpMsgs;
	}

	public Boolean getDoNotUseLDAPForLogin()
	{
		return doNotUseLDAPForLogin;
	}

	public Boolean getDoNotdispPrevRecInListView()
	{
		return doNotdispPrevRecInListView;
	}

	public Boolean getFullAuthority()
	{
		return fullAuthority;
	}

	public Boolean getLoginFromAppsOnly()
	{
		return loginFromAppsOnly;
	}

	public Boolean getPrevUserToRunSameRepMultipleTimes()
	{
		return prevUserToRunSameRepMultipleTimes;
	}

	public Boolean getRestrictAccessToLeads()
	{
		return restrictAccessToLeads;
	}

	public Boolean getViewSystemReports()
	{
		return viewSystemReports;
	}

	public DTOACCCustomSecurity getAccCustomSecurity()
	{
		return accCustomSecurity;
	}

	public DTOSCCustomSecurity getScCustomSecurity()
	{
		return scCustomSecurity;
	}

	public EntityReferenceData getCopyEntitiesFromMenu()
	{
		return copyEntitiesFromMenu;
	}

	public EntityReferenceData getDashBoard()
	{
		return dashBoard;
	}

	public EntityReferenceData getDefaultMenu()
	{
		return defaultMenu;
	}

	public EntityReferenceData getUsersCounter()
	{
		return usersCounter;
	}

	public Integer getMaxLoginSessions()
	{
		return maxLoginSessions;
	}

	public Integer getMaxNumberToRunReport()
	{
		return maxNumberToRunReport;
	}

	public Integer getMaxRecordsPerPageForListViews()
	{
		return maxRecordsPerPageForListViews;
	}

	public List<DTOActionSecurityLine> getActionLines()
	{
		return actionLines;
	}

	public List<DTOAllowItemInMenusLine> getAllowDisallowInMenus()
	{
		return allowDisallowInMenus;
	}

	public List<DTOCustomSecurityLine> getCustomLines()
	{
		return customLines;
	}

	public List<DTOExtraSecurityFilters> getExtraFilters()
	{
		return extraFilters;
	}

	public List<DTOGenericActionSecurityLine> getGenericActionLines()
	{
		return genericActionLines;
	}

	public List<DTOGenericCustomSecurityLine> getGenericCustomLines()
	{
		return genericCustomLines;
	}

	public List<DTOGenericSecurityFieldAuthority> getGenericDisabledFields()
	{
		return genericDisabledFields;
	}

	public List<DTOGenericStandardSecurityLine> getGenericStandardLines()
	{
		return genericStandardLines;
	}

	public List<DTOListViewSecurityLine> getListViewSecurityLines()
	{
		return listViewSecurityLines;
	}

	public List<DTOPageSecurity> getPageSecurity()
	{
		return pageSecurity;
	}

	public List<DTOSecurityFieldAuthority> getDisabledFields()
	{
		return disabledFields;
	}

	public List<DTOStandardSecurityLine> getStandardLines()
	{
		return standardLines;
	}

	public String getAllowAccessToAI()
	{
		return allowAccessToAI;
	}

	public String getCopyEntitiesFromGroup()
	{
		return copyEntitiesFromGroup;
	}

	public String getDefaultLayoutName()
	{
		return defaultLayoutName;
	}

	public String getEmailUsedWithSendAsEmailWindow()
	{
		return emailUsedWithSendAsEmailWindow;
	}

	public void setAccCustomSecurity(DTOACCCustomSecurity accCustomSecurity)
	{
		this.accCustomSecurity = accCustomSecurity;
	}

	public void setActionLines(List<DTOActionSecurityLine> actionLines)
	{
		this.actionLines = actionLines;
	}

	public void setAllowAccessToAI(String allowAccessToAI)
	{
		this.allowAccessToAI = allowAccessToAI;
	}

	public void setAllowDisallowInMenus(List<DTOAllowItemInMenusLine> allowDisallowInMenus)
	{
		this.allowDisallowInMenus = allowDisallowInMenus;
	}

	public void setAllowPDFPrintOnlyForForms(Boolean allowPDFPrintOnlyForForms)
	{
		this.allowPDFPrintOnlyForForms = allowPDFPrintOnlyForForms;
	}

	public void setAllowPDFPrintOnlyForReports(Boolean allowPDFPrintOnlyForReports)
	{
		this.allowPDFPrintOnlyForReports = allowPDFPrintOnlyForReports;
	}

	public void setAllowPreventedRecordsInInsert(Boolean allowPreventedRecordsInInsert)
	{
		this.allowPreventedRecordsInInsert = allowPreventedRecordsInInsert;
	}

	public void setAllowPreventedRecordsInUpdate(Boolean allowPreventedRecordsInUpdate)
	{
		this.allowPreventedRecordsInUpdate = allowPreventedRecordsInUpdate;
	}

	public void setAutoFetchUserShift(Boolean autoFetchUserShift)
	{
		this.autoFetchUserShift = autoFetchUserShift;
	}

	public void setAutoLogoutWithMaxSessions(Boolean autoLogoutWithMaxSessions)
	{
		this.autoLogoutWithMaxSessions = autoLogoutWithMaxSessions;
	}

	public void setCopyEntitiesFromGroup(String copyEntitiesFromGroup)
	{
		this.copyEntitiesFromGroup = copyEntitiesFromGroup;
	}

	public void setCopyEntitiesFromMenu(EntityReferenceData copyEntitiesFromMenu)
	{
		this.copyEntitiesFromMenu = copyEntitiesFromMenu;
	}

	public void setCustomLines(List<DTOCustomSecurityLine> customLines)
	{
		this.customLines = customLines;
	}

	public void setDashBoard(EntityReferenceData dashBoard)
	{
		this.dashBoard = dashBoard;
	}

	public void setDefaultLayoutName(String defaultLayoutName)
	{
		this.defaultLayoutName = defaultLayoutName;
	}

	public void setDefaultMenu(EntityReferenceData defaultMenu)
	{
		this.defaultMenu = defaultMenu;
	}

	public void setDisabledFields(List<DTOSecurityFieldAuthority> disabledFields)
	{
		this.disabledFields = disabledFields;
	}

	public void setDisplayPreventedRecords(Boolean displayPreventedRecords)
	{
		this.displayPreventedRecords = displayPreventedRecords;
	}

	public void setDoNotDisplayCriticalErrors(Boolean doNotDisplayCriticalErrors)
	{
		this.doNotDisplayCriticalErrors = doNotDisplayCriticalErrors;
	}

	public void setDoNotDisplaySystemHelpMsgs(Boolean doNotDisplaySystemHelpMsgs)
	{
		this.doNotDisplaySystemHelpMsgs = doNotDisplaySystemHelpMsgs;
	}

	public void setDoNotUseLDAPForLogin(Boolean doNotUseLDAPForLogin)
	{
		this.doNotUseLDAPForLogin = doNotUseLDAPForLogin;
	}

	public void setDoNotdispPrevRecInListView(Boolean doNotdispPrevRecInListView)
	{
		this.doNotdispPrevRecInListView = doNotdispPrevRecInListView;
	}

	public void setEmailUsedWithSendAsEmailWindow(String emailUsedWithSendAsEmailWindow)
	{
		this.emailUsedWithSendAsEmailWindow = emailUsedWithSendAsEmailWindow;
	}

	public void setExtraFilters(List<DTOExtraSecurityFilters> extraFilters)
	{
		this.extraFilters = extraFilters;
	}

	public void setFullAuthority(Boolean fullAuthority)
	{
		this.fullAuthority = fullAuthority;
	}

	public void setGenericActionLines(List<DTOGenericActionSecurityLine> genericActionLines)
	{
		this.genericActionLines = genericActionLines;
	}

	public void setGenericCustomLines(List<DTOGenericCustomSecurityLine> genericCustomLines)
	{
		this.genericCustomLines = genericCustomLines;
	}

	public void setGenericDisabledFields(List<DTOGenericSecurityFieldAuthority> genericDisabledFields)
	{
		this.genericDisabledFields = genericDisabledFields;
	}

	public void setGenericStandardLines(List<DTOGenericStandardSecurityLine> genericStandardLines)
	{
		this.genericStandardLines = genericStandardLines;
	}

	public void setListViewSecurityLines(List<DTOListViewSecurityLine> listViewSecurityLines)
	{
		this.listViewSecurityLines = listViewSecurityLines;
	}

	public void setLoginFromAppsOnly(Boolean loginFromAppsOnly)
	{
		this.loginFromAppsOnly = loginFromAppsOnly;
	}

	public void setMaxLoginSessions(Integer maxLoginSessions)
	{
		this.maxLoginSessions = maxLoginSessions;
	}

	public void setMaxNumberToRunReport(Integer maxNumberToRunReport)
	{
		this.maxNumberToRunReport = maxNumberToRunReport;
	}

	public void setMaxRecordsPerPageForListViews(Integer maxRecordsPerPageForListViews)
	{
		this.maxRecordsPerPageForListViews = maxRecordsPerPageForListViews;
	}

	public void setPageSecurity(List<DTOPageSecurity> pageSecurity)
	{
		this.pageSecurity = pageSecurity;
	}

	public void setPrevUserToRunSameRepMultipleTimes(Boolean prevUserToRunSameRepMultipleTimes)
	{
		this.prevUserToRunSameRepMultipleTimes = prevUserToRunSameRepMultipleTimes;
	}

	public void setRestrictAccessToLeads(Boolean restrictAccessToLeads)
	{
		this.restrictAccessToLeads = restrictAccessToLeads;
	}

	public void setScCustomSecurity(DTOSCCustomSecurity scCustomSecurity)
	{
		this.scCustomSecurity = scCustomSecurity;
	}

	public void setStandardLines(List<DTOStandardSecurityLine> standardLines)
	{
		this.standardLines = standardLines;
	}

	public void setUsersCounter(EntityReferenceData usersCounter)
	{
		this.usersCounter = usersCounter;
	}

	public void setViewSystemReports(Boolean viewSystemReports)
	{
		this.viewSystemReports = viewSystemReports;
	}

}
