package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DocumentFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOTaxAuthoritySubmissionLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOTaxAuthoritySubmissionDoc extends DocumentFileDTO implements Serializable
{
	private BigDecimal creditNoteTotalDiscount;
	private BigDecimal creditNoteTotalFinalNetValue;
	private BigDecimal creditNoteTotalNetValue;
	private BigDecimal creditNoteTotalPrice;
	private BigDecimal creditNoteTotalTaxValue;
	private BigDecimal debitNoteTotalDiscount;
	private BigDecimal debitNoteTotalFinalNetValue;
	private BigDecimal debitNoteTotalNetValue;
	private BigDecimal debitNoteTotalPrice;
	private BigDecimal debitNoteTotalTaxValue;
	private BigDecimal invoiceTotalDiscount;
	private BigDecimal invoiceTotalFinalNetValue;
	private BigDecimal invoiceTotalNetValue;
	private BigDecimal invoiceTotalPrice;
	private BigDecimal invoiceTotalTaxValue;
	private Date maxDateToCollectDocs;
	private Date minDateToCollectDocs;
	private EntityReferenceData collectFromDoc;
	private EntityReferenceData collectToDoc;
	private EntityReferenceData fromAnalysisSet;
	private EntityReferenceData fromBranch;
	private EntityReferenceData fromDepartment;
	private EntityReferenceData fromLegalEntity;
	private EntityReferenceData fromSector;
	private EntityReferenceData taxConfiguration;
	private EntityReferenceData toAnalysisSet;
	private EntityReferenceData toBranch;
	private EntityReferenceData toDepartment;
	private EntityReferenceData toLegalEntity;
	private EntityReferenceData toSector;
	private List<DTOTaxAuthoritySubmissionLine> toSubmitLines = new ArrayList<DTOTaxAuthoritySubmissionLine>();
	private String collectOnlyEntityType;
	private String docsWithoutSignatures;
	private String einvoiceSignerPin;
	private String einvoiceSignerType;
	private String einvoiceSignerUrl;
	public BigDecimal getCreditNoteTotalDiscount()
	{
		return creditNoteTotalDiscount;
	}

	public BigDecimal getCreditNoteTotalFinalNetValue()
	{
		return creditNoteTotalFinalNetValue;
	}

	public BigDecimal getCreditNoteTotalNetValue()
	{
		return creditNoteTotalNetValue;
	}

	public BigDecimal getCreditNoteTotalPrice()
	{
		return creditNoteTotalPrice;
	}

	public BigDecimal getCreditNoteTotalTaxValue()
	{
		return creditNoteTotalTaxValue;
	}

	public BigDecimal getDebitNoteTotalDiscount()
	{
		return debitNoteTotalDiscount;
	}

	public BigDecimal getDebitNoteTotalFinalNetValue()
	{
		return debitNoteTotalFinalNetValue;
	}

	public BigDecimal getDebitNoteTotalNetValue()
	{
		return debitNoteTotalNetValue;
	}

	public BigDecimal getDebitNoteTotalPrice()
	{
		return debitNoteTotalPrice;
	}

	public BigDecimal getDebitNoteTotalTaxValue()
	{
		return debitNoteTotalTaxValue;
	}

	public BigDecimal getInvoiceTotalDiscount()
	{
		return invoiceTotalDiscount;
	}

	public BigDecimal getInvoiceTotalFinalNetValue()
	{
		return invoiceTotalFinalNetValue;
	}

	public BigDecimal getInvoiceTotalNetValue()
	{
		return invoiceTotalNetValue;
	}

	public BigDecimal getInvoiceTotalPrice()
	{
		return invoiceTotalPrice;
	}

	public BigDecimal getInvoiceTotalTaxValue()
	{
		return invoiceTotalTaxValue;
	}

	public Date getMaxDateToCollectDocs()
	{
		return maxDateToCollectDocs;
	}

	public Date getMinDateToCollectDocs()
	{
		return minDateToCollectDocs;
	}

	public EntityReferenceData getCollectFromDoc()
	{
		return collectFromDoc;
	}

	public EntityReferenceData getCollectToDoc()
	{
		return collectToDoc;
	}

	public EntityReferenceData getFromAnalysisSet()
	{
		return fromAnalysisSet;
	}

	public EntityReferenceData getFromBranch()
	{
		return fromBranch;
	}

	public EntityReferenceData getFromDepartment()
	{
		return fromDepartment;
	}

	public EntityReferenceData getFromLegalEntity()
	{
		return fromLegalEntity;
	}

	public EntityReferenceData getFromSector()
	{
		return fromSector;
	}

	public EntityReferenceData getTaxConfiguration()
	{
		return taxConfiguration;
	}

	public EntityReferenceData getToAnalysisSet()
	{
		return toAnalysisSet;
	}

	public EntityReferenceData getToBranch()
	{
		return toBranch;
	}

	public EntityReferenceData getToDepartment()
	{
		return toDepartment;
	}

	public EntityReferenceData getToLegalEntity()
	{
		return toLegalEntity;
	}

	public EntityReferenceData getToSector()
	{
		return toSector;
	}

	public List<DTOTaxAuthoritySubmissionLine> getToSubmitLines()
	{
		return toSubmitLines;
	}

	public String getCollectOnlyEntityType()
	{
		return collectOnlyEntityType;
	}

	public String getDocsWithoutSignatures()
	{
		return docsWithoutSignatures;
	}

	public String getEinvoiceSignerPin()
	{
		return einvoiceSignerPin;
	}

	public String getEinvoiceSignerType()
	{
		return einvoiceSignerType;
	}

	public String getEinvoiceSignerUrl()
	{
		return einvoiceSignerUrl;
	}

	public void setCollectFromDoc(EntityReferenceData collectFromDoc)
	{
		this.collectFromDoc = collectFromDoc;
	}

	public void setCollectOnlyEntityType(String collectOnlyEntityType)
	{
		this.collectOnlyEntityType = collectOnlyEntityType;
	}

	public void setCollectToDoc(EntityReferenceData collectToDoc)
	{
		this.collectToDoc = collectToDoc;
	}

	public void setCreditNoteTotalDiscount(BigDecimal creditNoteTotalDiscount)
	{
		this.creditNoteTotalDiscount = creditNoteTotalDiscount;
	}

	public void setCreditNoteTotalFinalNetValue(BigDecimal creditNoteTotalFinalNetValue)
	{
		this.creditNoteTotalFinalNetValue = creditNoteTotalFinalNetValue;
	}

	public void setCreditNoteTotalNetValue(BigDecimal creditNoteTotalNetValue)
	{
		this.creditNoteTotalNetValue = creditNoteTotalNetValue;
	}

	public void setCreditNoteTotalPrice(BigDecimal creditNoteTotalPrice)
	{
		this.creditNoteTotalPrice = creditNoteTotalPrice;
	}

	public void setCreditNoteTotalTaxValue(BigDecimal creditNoteTotalTaxValue)
	{
		this.creditNoteTotalTaxValue = creditNoteTotalTaxValue;
	}

	public void setDebitNoteTotalDiscount(BigDecimal debitNoteTotalDiscount)
	{
		this.debitNoteTotalDiscount = debitNoteTotalDiscount;
	}

	public void setDebitNoteTotalFinalNetValue(BigDecimal debitNoteTotalFinalNetValue)
	{
		this.debitNoteTotalFinalNetValue = debitNoteTotalFinalNetValue;
	}

	public void setDebitNoteTotalNetValue(BigDecimal debitNoteTotalNetValue)
	{
		this.debitNoteTotalNetValue = debitNoteTotalNetValue;
	}

	public void setDebitNoteTotalPrice(BigDecimal debitNoteTotalPrice)
	{
		this.debitNoteTotalPrice = debitNoteTotalPrice;
	}

	public void setDebitNoteTotalTaxValue(BigDecimal debitNoteTotalTaxValue)
	{
		this.debitNoteTotalTaxValue = debitNoteTotalTaxValue;
	}

	public void setDocsWithoutSignatures(String docsWithoutSignatures)
	{
		this.docsWithoutSignatures = docsWithoutSignatures;
	}

	public void setEinvoiceSignerPin(String einvoiceSignerPin)
	{
		this.einvoiceSignerPin = einvoiceSignerPin;
	}

	public void setEinvoiceSignerType(String einvoiceSignerType)
	{
		this.einvoiceSignerType = einvoiceSignerType;
	}

	public void setEinvoiceSignerUrl(String einvoiceSignerUrl)
	{
		this.einvoiceSignerUrl = einvoiceSignerUrl;
	}

	public void setFromAnalysisSet(EntityReferenceData fromAnalysisSet)
	{
		this.fromAnalysisSet = fromAnalysisSet;
	}

	public void setFromBranch(EntityReferenceData fromBranch)
	{
		this.fromBranch = fromBranch;
	}

	public void setFromDepartment(EntityReferenceData fromDepartment)
	{
		this.fromDepartment = fromDepartment;
	}

	public void setFromLegalEntity(EntityReferenceData fromLegalEntity)
	{
		this.fromLegalEntity = fromLegalEntity;
	}

	public void setFromSector(EntityReferenceData fromSector)
	{
		this.fromSector = fromSector;
	}

	public void setInvoiceTotalDiscount(BigDecimal invoiceTotalDiscount)
	{
		this.invoiceTotalDiscount = invoiceTotalDiscount;
	}

	public void setInvoiceTotalFinalNetValue(BigDecimal invoiceTotalFinalNetValue)
	{
		this.invoiceTotalFinalNetValue = invoiceTotalFinalNetValue;
	}

	public void setInvoiceTotalNetValue(BigDecimal invoiceTotalNetValue)
	{
		this.invoiceTotalNetValue = invoiceTotalNetValue;
	}

	public void setInvoiceTotalPrice(BigDecimal invoiceTotalPrice)
	{
		this.invoiceTotalPrice = invoiceTotalPrice;
	}

	public void setInvoiceTotalTaxValue(BigDecimal invoiceTotalTaxValue)
	{
		this.invoiceTotalTaxValue = invoiceTotalTaxValue;
	}

	public void setMaxDateToCollectDocs(Date maxDateToCollectDocs)
	{
		this.maxDateToCollectDocs = maxDateToCollectDocs;
	}

	public void setMinDateToCollectDocs(Date minDateToCollectDocs)
	{
		this.minDateToCollectDocs = minDateToCollectDocs;
	}

	public void setTaxConfiguration(EntityReferenceData taxConfiguration)
	{
		this.taxConfiguration = taxConfiguration;
	}

	public void setToAnalysisSet(EntityReferenceData toAnalysisSet)
	{
		this.toAnalysisSet = toAnalysisSet;
	}

	public void setToBranch(EntityReferenceData toBranch)
	{
		this.toBranch = toBranch;
	}

	public void setToDepartment(EntityReferenceData toDepartment)
	{
		this.toDepartment = toDepartment;
	}

	public void setToLegalEntity(EntityReferenceData toLegalEntity)
	{
		this.toLegalEntity = toLegalEntity;
	}

	public void setToSector(EntityReferenceData toSector)
	{
		this.toSector = toSector;
	}

	public void setToSubmitLines(List<DTOTaxAuthoritySubmissionLine> toSubmitLines)
	{
		this.toSubmitLines = toSubmitLines;
	}

}
