package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOEInvoiceConfigLine;
import com.namasoft.modules.commonbasic.contracts.details.DTOEInvoiceDiscountConfigLine;
import com.namasoft.modules.commonbasic.contracts.details.DTOServiceFeesAndChargesToCustomerConfig;
import com.namasoft.modules.commonbasic.contracts.details.DTOTaxConfigurationCodeSource;
import com.namasoft.modules.commonbasic.contracts.details.DTOTaxConfigurationPOSTerminalLine;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOTaxesCodes;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOTaxPayerConfiguration extends MasterFileDTO implements Serializable
{
	private BigDecimal chargesFeeTaxPercent;
	private BigDecimal minInvValueCustomerRequired;
	private BigDecimal minReceiptValueCustomerRequired;
	private Boolean chargesFeeIncludeTax;
	private Boolean doNotSendTax1IfNoCode;
	private Boolean doNotSendTax2IfNoCode;
	private Boolean doNotSendTax3IfNoCode;
	private Boolean doNotSendTax4IfNoCode;
	private Boolean ignoreAndRoundAmountIfScaleIsInvalid;
	private Boolean sendSignedDocuments;
	private Boolean signDocumentOnServerSide;
	private Boolean simplifiedInvoices;
	private Boolean standardInvoices;
	private Boolean validateEGSCodes;
	private DTOTaxesCodes taxesCodes;
	private Date allowSendPastEInvoiceFromDate;
	private Date allowSendPastEInvoiceToDate;
	private Date lastNotificationReadTime;
	private Date lastReadSubmissionDateForReceivedDocuments;
	private Date startSendingFromDate;
	private EntityReferenceData notificationReadTask;
	private EntityReferenceData taxEInvoiceBook;
	private EntityReferenceData taxEInvoiceTerm;
	private Integer futureDaysToAllowSaveDoc;
	private Integer internalItemCodeMaxLength;
	private Integer maxDaysToCancelInvoice;
	private Integer maxDaysToSendInvoice;
	private Integer maxDocumentsPerRequest;
	private Integer quantityFractionalPlaces;
	private List<DTOEInvoiceConfigLine> configs = new ArrayList<DTOEInvoiceConfigLine>();
	private List<DTOEInvoiceDiscountConfigLine> discountConfigs = new ArrayList<DTOEInvoiceDiscountConfigLine>();
	private List<DTOServiceFeesAndChargesToCustomerConfig> serviceFeesAndChargesToCustomerConfigs = new ArrayList<DTOServiceFeesAndChargesToCustomerConfig>();
	private List<DTOTaxConfigurationCodeSource> taxCodesSource = new ArrayList<DTOTaxConfigurationCodeSource>();
	private List<DTOTaxConfigurationPOSTerminalLine> posTerminals = new ArrayList<DTOTaxConfigurationPOSTerminalLine>();
	private String activityType;
	private String apiKey;
	private String apiUrl;
	private String branchIdDimension;
	private String branchTaxAuthorityCodeTemplate;
	private String chargesFeeFields;
	private String customerAdditionalInfoTemplate;
	private String egsSerialNumber;
	private String einvoiceDocType;
	private String einvoiceSignerPin;
	private String einvoiceSignerType;
	private String einvoiceSignerUrl;
	private String esignerExecutionFile;
	private String esignerInstalltionFolder;
	private String identityUrl;
	private String ignoreItemWithTaxCode;
	private String intermediaryServerClientId;
	private String intermediaryServerClientSecret;
	private String intermediaryServerUrl;
	private String internalCodeFrom;
	private String internalCodeTemplate;
	private String itemCodeFrom;
	private String itemCodeTemplate;
	private String organizationUnitName;
	private String password;
	private String portalUrl;
	private String posClientId;
	private String posClientSecret;
	private String posModelFramework;
	private String posOSVersion;
	private String posSerialNumber;
	private String receiverMode;
	private String syndicateLicenseNumber;
	private String taxCodesType;
	private String taxDescriptionFrom;
	private String taxDescriptionTemplate;
	private String taxPayerType;
	private String taxRegNo;
	private String unitPriceSource;
	private String unitPriceType;
	private String userName;
	private String zatcaCSIDResponse;
	private String zatcaSignAPIPassword;
	public BigDecimal getChargesFeeTaxPercent()
	{
		return chargesFeeTaxPercent;
	}

	public BigDecimal getMinInvValueCustomerRequired()
	{
		return minInvValueCustomerRequired;
	}

	public BigDecimal getMinReceiptValueCustomerRequired()
	{
		return minReceiptValueCustomerRequired;
	}

	public Boolean getChargesFeeIncludeTax()
	{
		return chargesFeeIncludeTax;
	}

	public Boolean getDoNotSendTax1IfNoCode()
	{
		return doNotSendTax1IfNoCode;
	}

	public Boolean getDoNotSendTax2IfNoCode()
	{
		return doNotSendTax2IfNoCode;
	}

	public Boolean getDoNotSendTax3IfNoCode()
	{
		return doNotSendTax3IfNoCode;
	}

	public Boolean getDoNotSendTax4IfNoCode()
	{
		return doNotSendTax4IfNoCode;
	}

	public Boolean getIgnoreAndRoundAmountIfScaleIsInvalid()
	{
		return ignoreAndRoundAmountIfScaleIsInvalid;
	}

	public Boolean getSendSignedDocuments()
	{
		return sendSignedDocuments;
	}

	public Boolean getSignDocumentOnServerSide()
	{
		return signDocumentOnServerSide;
	}

	public Boolean getSimplifiedInvoices()
	{
		return simplifiedInvoices;
	}

	public Boolean getStandardInvoices()
	{
		return standardInvoices;
	}

	public Boolean getValidateEGSCodes()
	{
		return validateEGSCodes;
	}

	public DTOTaxesCodes getTaxesCodes()
	{
		return taxesCodes;
	}

	public Date getAllowSendPastEInvoiceFromDate()
	{
		return allowSendPastEInvoiceFromDate;
	}

	public Date getAllowSendPastEInvoiceToDate()
	{
		return allowSendPastEInvoiceToDate;
	}

	public Date getLastNotificationReadTime()
	{
		return lastNotificationReadTime;
	}

	public Date getLastReadSubmissionDateForReceivedDocuments()
	{
		return lastReadSubmissionDateForReceivedDocuments;
	}

	public Date getStartSendingFromDate()
	{
		return startSendingFromDate;
	}

	public EntityReferenceData getNotificationReadTask()
	{
		return notificationReadTask;
	}

	public EntityReferenceData getTaxEInvoiceBook()
	{
		return taxEInvoiceBook;
	}

	public EntityReferenceData getTaxEInvoiceTerm()
	{
		return taxEInvoiceTerm;
	}

	public Integer getFutureDaysToAllowSaveDoc()
	{
		return futureDaysToAllowSaveDoc;
	}

	public Integer getInternalItemCodeMaxLength()
	{
		return internalItemCodeMaxLength;
	}

	public Integer getMaxDaysToCancelInvoice()
	{
		return maxDaysToCancelInvoice;
	}

	public Integer getMaxDaysToSendInvoice()
	{
		return maxDaysToSendInvoice;
	}

	public Integer getMaxDocumentsPerRequest()
	{
		return maxDocumentsPerRequest;
	}

	public Integer getQuantityFractionalPlaces()
	{
		return quantityFractionalPlaces;
	}

	public List<DTOEInvoiceConfigLine> getConfigs()
	{
		return configs;
	}

	public List<DTOEInvoiceDiscountConfigLine> getDiscountConfigs()
	{
		return discountConfigs;
	}

	public List<DTOServiceFeesAndChargesToCustomerConfig> getServiceFeesAndChargesToCustomerConfigs()
	{
		return serviceFeesAndChargesToCustomerConfigs;
	}

	public List<DTOTaxConfigurationCodeSource> getTaxCodesSource()
	{
		return taxCodesSource;
	}

	public List<DTOTaxConfigurationPOSTerminalLine> getPosTerminals()
	{
		return posTerminals;
	}

	public String getActivityType()
	{
		return activityType;
	}

	public String getApiKey()
	{
		return apiKey;
	}

	public String getApiUrl()
	{
		return apiUrl;
	}

	public String getBranchIdDimension()
	{
		return branchIdDimension;
	}

	public String getBranchTaxAuthorityCodeTemplate()
	{
		return branchTaxAuthorityCodeTemplate;
	}

	public String getChargesFeeFields()
	{
		return chargesFeeFields;
	}

	public String getCustomerAdditionalInfoTemplate()
	{
		return customerAdditionalInfoTemplate;
	}

	public String getEgsSerialNumber()
	{
		return egsSerialNumber;
	}

	public String getEinvoiceDocType()
	{
		return einvoiceDocType;
	}

	public String getEinvoiceSignerPin()
	{
		return einvoiceSignerPin;
	}

	public String getEinvoiceSignerType()
	{
		return einvoiceSignerType;
	}

	public String getEinvoiceSignerUrl()
	{
		return einvoiceSignerUrl;
	}

	public String getEsignerExecutionFile()
	{
		return esignerExecutionFile;
	}

	public String getEsignerInstalltionFolder()
	{
		return esignerInstalltionFolder;
	}

	public String getIdentityUrl()
	{
		return identityUrl;
	}

	public String getIgnoreItemWithTaxCode()
	{
		return ignoreItemWithTaxCode;
	}

	public String getIntermediaryServerClientId()
	{
		return intermediaryServerClientId;
	}

	public String getIntermediaryServerClientSecret()
	{
		return intermediaryServerClientSecret;
	}

	public String getIntermediaryServerUrl()
	{
		return intermediaryServerUrl;
	}

	public String getInternalCodeFrom()
	{
		return internalCodeFrom;
	}

	public String getInternalCodeTemplate()
	{
		return internalCodeTemplate;
	}

	public String getItemCodeFrom()
	{
		return itemCodeFrom;
	}

	public String getItemCodeTemplate()
	{
		return itemCodeTemplate;
	}

	public String getOrganizationUnitName()
	{
		return organizationUnitName;
	}

	public String getPassword()
	{
		return password;
	}

	public String getPortalUrl()
	{
		return portalUrl;
	}

	public String getPosClientId()
	{
		return posClientId;
	}

	public String getPosClientSecret()
	{
		return posClientSecret;
	}

	public String getPosModelFramework()
	{
		return posModelFramework;
	}

	public String getPosOSVersion()
	{
		return posOSVersion;
	}

	public String getPosSerialNumber()
	{
		return posSerialNumber;
	}

	public String getReceiverMode()
	{
		return receiverMode;
	}

	public String getSyndicateLicenseNumber()
	{
		return syndicateLicenseNumber;
	}

	public String getTaxCodesType()
	{
		return taxCodesType;
	}

	public String getTaxDescriptionFrom()
	{
		return taxDescriptionFrom;
	}

	public String getTaxDescriptionTemplate()
	{
		return taxDescriptionTemplate;
	}

	public String getTaxPayerType()
	{
		return taxPayerType;
	}

	public String getTaxRegNo()
	{
		return taxRegNo;
	}

	public String getUnitPriceSource()
	{
		return unitPriceSource;
	}

	public String getUnitPriceType()
	{
		return unitPriceType;
	}

	public String getUserName()
	{
		return userName;
	}

	public String getZatcaCSIDResponse()
	{
		return zatcaCSIDResponse;
	}

	public String getZatcaSignAPIPassword()
	{
		return zatcaSignAPIPassword;
	}

	public void setActivityType(String activityType)
	{
		this.activityType = activityType;
	}

	public void setAllowSendPastEInvoiceFromDate(Date allowSendPastEInvoiceFromDate)
	{
		this.allowSendPastEInvoiceFromDate = allowSendPastEInvoiceFromDate;
	}

	public void setAllowSendPastEInvoiceToDate(Date allowSendPastEInvoiceToDate)
	{
		this.allowSendPastEInvoiceToDate = allowSendPastEInvoiceToDate;
	}

	public void setApiKey(String apiKey)
	{
		this.apiKey = apiKey;
	}

	public void setApiUrl(String apiUrl)
	{
		this.apiUrl = apiUrl;
	}

	public void setBranchIdDimension(String branchIdDimension)
	{
		this.branchIdDimension = branchIdDimension;
	}

	public void setBranchTaxAuthorityCodeTemplate(String branchTaxAuthorityCodeTemplate)
	{
		this.branchTaxAuthorityCodeTemplate = branchTaxAuthorityCodeTemplate;
	}

	public void setChargesFeeFields(String chargesFeeFields)
	{
		this.chargesFeeFields = chargesFeeFields;
	}

	public void setChargesFeeIncludeTax(Boolean chargesFeeIncludeTax)
	{
		this.chargesFeeIncludeTax = chargesFeeIncludeTax;
	}

	public void setChargesFeeTaxPercent(BigDecimal chargesFeeTaxPercent)
	{
		this.chargesFeeTaxPercent = chargesFeeTaxPercent;
	}

	public void setConfigs(List<DTOEInvoiceConfigLine> configs)
	{
		this.configs = configs;
	}

	public void setCustomerAdditionalInfoTemplate(String customerAdditionalInfoTemplate)
	{
		this.customerAdditionalInfoTemplate = customerAdditionalInfoTemplate;
	}

	public void setDiscountConfigs(List<DTOEInvoiceDiscountConfigLine> discountConfigs)
	{
		this.discountConfigs = discountConfigs;
	}

	public void setDoNotSendTax1IfNoCode(Boolean doNotSendTax1IfNoCode)
	{
		this.doNotSendTax1IfNoCode = doNotSendTax1IfNoCode;
	}

	public void setDoNotSendTax2IfNoCode(Boolean doNotSendTax2IfNoCode)
	{
		this.doNotSendTax2IfNoCode = doNotSendTax2IfNoCode;
	}

	public void setDoNotSendTax3IfNoCode(Boolean doNotSendTax3IfNoCode)
	{
		this.doNotSendTax3IfNoCode = doNotSendTax3IfNoCode;
	}

	public void setDoNotSendTax4IfNoCode(Boolean doNotSendTax4IfNoCode)
	{
		this.doNotSendTax4IfNoCode = doNotSendTax4IfNoCode;
	}

	public void setEgsSerialNumber(String egsSerialNumber)
	{
		this.egsSerialNumber = egsSerialNumber;
	}

	public void setEinvoiceDocType(String einvoiceDocType)
	{
		this.einvoiceDocType = einvoiceDocType;
	}

	public void setEinvoiceSignerPin(String einvoiceSignerPin)
	{
		this.einvoiceSignerPin = einvoiceSignerPin;
	}

	public void setEinvoiceSignerType(String einvoiceSignerType)
	{
		this.einvoiceSignerType = einvoiceSignerType;
	}

	public void setEinvoiceSignerUrl(String einvoiceSignerUrl)
	{
		this.einvoiceSignerUrl = einvoiceSignerUrl;
	}

	public void setEsignerExecutionFile(String esignerExecutionFile)
	{
		this.esignerExecutionFile = esignerExecutionFile;
	}

	public void setEsignerInstalltionFolder(String esignerInstalltionFolder)
	{
		this.esignerInstalltionFolder = esignerInstalltionFolder;
	}

	public void setFutureDaysToAllowSaveDoc(Integer futureDaysToAllowSaveDoc)
	{
		this.futureDaysToAllowSaveDoc = futureDaysToAllowSaveDoc;
	}

	public void setIdentityUrl(String identityUrl)
	{
		this.identityUrl = identityUrl;
	}

	public void setIgnoreAndRoundAmountIfScaleIsInvalid(Boolean ignoreAndRoundAmountIfScaleIsInvalid)
	{
		this.ignoreAndRoundAmountIfScaleIsInvalid = ignoreAndRoundAmountIfScaleIsInvalid;
	}

	public void setIgnoreItemWithTaxCode(String ignoreItemWithTaxCode)
	{
		this.ignoreItemWithTaxCode = ignoreItemWithTaxCode;
	}

	public void setIntermediaryServerClientId(String intermediaryServerClientId)
	{
		this.intermediaryServerClientId = intermediaryServerClientId;
	}

	public void setIntermediaryServerClientSecret(String intermediaryServerClientSecret)
	{
		this.intermediaryServerClientSecret = intermediaryServerClientSecret;
	}

	public void setIntermediaryServerUrl(String intermediaryServerUrl)
	{
		this.intermediaryServerUrl = intermediaryServerUrl;
	}

	public void setInternalCodeFrom(String internalCodeFrom)
	{
		this.internalCodeFrom = internalCodeFrom;
	}

	public void setInternalCodeTemplate(String internalCodeTemplate)
	{
		this.internalCodeTemplate = internalCodeTemplate;
	}

	public void setInternalItemCodeMaxLength(Integer internalItemCodeMaxLength)
	{
		this.internalItemCodeMaxLength = internalItemCodeMaxLength;
	}

	public void setItemCodeFrom(String itemCodeFrom)
	{
		this.itemCodeFrom = itemCodeFrom;
	}

	public void setItemCodeTemplate(String itemCodeTemplate)
	{
		this.itemCodeTemplate = itemCodeTemplate;
	}

	public void setLastNotificationReadTime(Date lastNotificationReadTime)
	{
		this.lastNotificationReadTime = lastNotificationReadTime;
	}

	public void setLastReadSubmissionDateForReceivedDocuments(Date lastReadSubmissionDateForReceivedDocuments)
	{
		this.lastReadSubmissionDateForReceivedDocuments = lastReadSubmissionDateForReceivedDocuments;
	}

	public void setMaxDaysToCancelInvoice(Integer maxDaysToCancelInvoice)
	{
		this.maxDaysToCancelInvoice = maxDaysToCancelInvoice;
	}

	public void setMaxDaysToSendInvoice(Integer maxDaysToSendInvoice)
	{
		this.maxDaysToSendInvoice = maxDaysToSendInvoice;
	}

	public void setMaxDocumentsPerRequest(Integer maxDocumentsPerRequest)
	{
		this.maxDocumentsPerRequest = maxDocumentsPerRequest;
	}

	public void setMinInvValueCustomerRequired(BigDecimal minInvValueCustomerRequired)
	{
		this.minInvValueCustomerRequired = minInvValueCustomerRequired;
	}

	public void setMinReceiptValueCustomerRequired(BigDecimal minReceiptValueCustomerRequired)
	{
		this.minReceiptValueCustomerRequired = minReceiptValueCustomerRequired;
	}

	public void setNotificationReadTask(EntityReferenceData notificationReadTask)
	{
		this.notificationReadTask = notificationReadTask;
	}

	public void setOrganizationUnitName(String organizationUnitName)
	{
		this.organizationUnitName = organizationUnitName;
	}

	public void setPassword(String password)
	{
		this.password = password;
	}

	public void setPortalUrl(String portalUrl)
	{
		this.portalUrl = portalUrl;
	}

	public void setPosClientId(String posClientId)
	{
		this.posClientId = posClientId;
	}

	public void setPosClientSecret(String posClientSecret)
	{
		this.posClientSecret = posClientSecret;
	}

	public void setPosModelFramework(String posModelFramework)
	{
		this.posModelFramework = posModelFramework;
	}

	public void setPosOSVersion(String posOSVersion)
	{
		this.posOSVersion = posOSVersion;
	}

	public void setPosSerialNumber(String posSerialNumber)
	{
		this.posSerialNumber = posSerialNumber;
	}

	public void setPosTerminals(List<DTOTaxConfigurationPOSTerminalLine> posTerminals)
	{
		this.posTerminals = posTerminals;
	}

	public void setQuantityFractionalPlaces(Integer quantityFractionalPlaces)
	{
		this.quantityFractionalPlaces = quantityFractionalPlaces;
	}

	public void setReceiverMode(String receiverMode)
	{
		this.receiverMode = receiverMode;
	}

	public void setSendSignedDocuments(Boolean sendSignedDocuments)
	{
		this.sendSignedDocuments = sendSignedDocuments;
	}

	public void setServiceFeesAndChargesToCustomerConfigs(List<DTOServiceFeesAndChargesToCustomerConfig> serviceFeesAndChargesToCustomerConfigs)
	{
		this.serviceFeesAndChargesToCustomerConfigs = serviceFeesAndChargesToCustomerConfigs;
	}

	public void setSignDocumentOnServerSide(Boolean signDocumentOnServerSide)
	{
		this.signDocumentOnServerSide = signDocumentOnServerSide;
	}

	public void setSimplifiedInvoices(Boolean simplifiedInvoices)
	{
		this.simplifiedInvoices = simplifiedInvoices;
	}

	public void setStandardInvoices(Boolean standardInvoices)
	{
		this.standardInvoices = standardInvoices;
	}

	public void setStartSendingFromDate(Date startSendingFromDate)
	{
		this.startSendingFromDate = startSendingFromDate;
	}

	public void setSyndicateLicenseNumber(String syndicateLicenseNumber)
	{
		this.syndicateLicenseNumber = syndicateLicenseNumber;
	}

	public void setTaxCodesSource(List<DTOTaxConfigurationCodeSource> taxCodesSource)
	{
		this.taxCodesSource = taxCodesSource;
	}

	public void setTaxCodesType(String taxCodesType)
	{
		this.taxCodesType = taxCodesType;
	}

	public void setTaxDescriptionFrom(String taxDescriptionFrom)
	{
		this.taxDescriptionFrom = taxDescriptionFrom;
	}

	public void setTaxDescriptionTemplate(String taxDescriptionTemplate)
	{
		this.taxDescriptionTemplate = taxDescriptionTemplate;
	}

	public void setTaxEInvoiceBook(EntityReferenceData taxEInvoiceBook)
	{
		this.taxEInvoiceBook = taxEInvoiceBook;
	}

	public void setTaxEInvoiceTerm(EntityReferenceData taxEInvoiceTerm)
	{
		this.taxEInvoiceTerm = taxEInvoiceTerm;
	}

	public void setTaxPayerType(String taxPayerType)
	{
		this.taxPayerType = taxPayerType;
	}

	public void setTaxRegNo(String taxRegNo)
	{
		this.taxRegNo = taxRegNo;
	}

	public void setTaxesCodes(DTOTaxesCodes taxesCodes)
	{
		this.taxesCodes = taxesCodes;
	}

	public void setUnitPriceSource(String unitPriceSource)
	{
		this.unitPriceSource = unitPriceSource;
	}

	public void setUnitPriceType(String unitPriceType)
	{
		this.unitPriceType = unitPriceType;
	}

	public void setUserName(String userName)
	{
		this.userName = userName;
	}

	public void setValidateEGSCodes(Boolean validateEGSCodes)
	{
		this.validateEGSCodes = validateEGSCodes;
	}

	public void setZatcaCSIDResponse(String zatcaCSIDResponse)
	{
		this.zatcaCSIDResponse = zatcaCSIDResponse;
	}

	public void setZatcaSignAPIPassword(String zatcaSignAPIPassword)
	{
		this.zatcaSignAPIPassword = zatcaSignAPIPassword;
	}

}
