package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.modules.commonbasic.contracts.details.DTOUserFavouritesApplyTo;
import com.namasoft.modules.commonbasic.contracts.details.DTOUserFavouritesGroupsLine;
import com.namasoft.modules.commonbasic.contracts.details.DTOUserFavouritesLine;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOUserFavourites extends MasterFileDTO implements Serializable
{
	private EntityReferenceData forUser;
	private Integer priority;
	private List<DTOUserFavouritesApplyTo> applyTo = new ArrayList<DTOUserFavouritesApplyTo>();
	private List<DTOUserFavouritesGroupsLine> groupsLines = new ArrayList<DTOUserFavouritesGroupsLine>();
	private List<DTOUserFavouritesLine> favouriteItems = new ArrayList<DTOUserFavouritesLine>();
	public EntityReferenceData getForUser()
	{
		return forUser;
	}

	public Integer getPriority()
	{
		return priority;
	}

	public List<DTOUserFavouritesApplyTo> getApplyTo()
	{
		return applyTo;
	}

	public List<DTOUserFavouritesGroupsLine> getGroupsLines()
	{
		return groupsLines;
	}

	public List<DTOUserFavouritesLine> getFavouriteItems()
	{
		return favouriteItems;
	}

	public void setApplyTo(List<DTOUserFavouritesApplyTo> applyTo)
	{
		this.applyTo = applyTo;
	}

	public void setFavouriteItems(List<DTOUserFavouritesLine> favouriteItems)
	{
		this.favouriteItems = favouriteItems;
	}

	public void setForUser(EntityReferenceData forUser)
	{
		this.forUser = forUser;
	}

	public void setGroupsLines(List<DTOUserFavouritesGroupsLine> groupsLines)
	{
		this.groupsLines = groupsLines;
	}

	public void setPriority(Integer priority)
	{
		this.priority = priority;
	}

}
