package com.namasoft.modules.commonbasic.contracts.entities;

import com.namasoft.modules.commonbasic.contracts.details.IDTOStandardTermLine;

import java.util.List;
import java.util.stream.Collectors;

public interface IDTOHasStandardTermLines
{
	List<? extends IDTOStandardTermLine> fetchTermLines();

	default List<String> standardTermIds()
	{
		return fetchTermLines().stream().filter(l -> l.getStandardTerm() != null).map(l -> l.getStandardTerm().getId()).distinct().collect(Collectors.toList());
	}
}
