package com.namasoft.modules.commonbasic.contracts.invoicing;

import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.*;
import com.namasoft.modules.commonbasic.contracts.valueobjects.*;

import java.math.BigDecimal;
import java.util.List;

public interface IDTOInvoiceLine
{
	DTOInvoiceLineMoney getPrice();

	void setPrice(DTOInvoiceLineMoney price);

	BigDecimal unitQuantity();

	default EntityReferenceData subjectedMF(){
		return null;
	}

	Boolean isFreeLine();

	void updateQtyVal(BigDecimal qty);

	void setPrimQtyUom(EntityReferenceData uom);

	default String subjectDFCode(){
		return null;
	}

	default boolean customTotalFor(MoneyEffectType effectType)
	{
		return false;
	}

	default BigDecimal totalFor(MoneyEffectType effectType, BigDecimal currentTotal, List<SimpleEntry<MoneyEffectType, DTOMoneyEffectDetails>> effects, BigDecimal mainPrice,
			DTOTaxConfiguration taxConfiguration)
	{
		throw new NaMaServiceExcepption("Unhandled method");
	}

	String calcMasterRowId();

	default boolean canBeNegative()
	{
		return false;
	}

	default void updateNulls()
	{
		if (getPrice() == null)
			setPrice(new DTOInvoiceLineMoney());
		getPrice().updateNulls();
	}
}
