package com.namasoft.modules.commonbasic.contracts.invoicing;

import com.namasoft.common.flatobjects.EntityReferenceData;

public interface IDTOItemSpecificDimensions
{

	String fetchSize();

	String fetchColor();

	String fetchMeasures();

	String fetchLotId();

	String fetchSerialNumber();

	String fetchSecondSerial();

	String fetchBox();

	String fetchRevisionId();

	String fetchActivePerc();

	String fetchInactivePerc();

	EntityReferenceData fetchSubItem();

	class SimpleDTOItemSpecificDimensions implements IDTOItemSpecificDimensions
	{
		private String size;
		private String color;
		private String measures;
		private String lotId;
		private String serialNumber;
		private String secondSerial;
		private String box;
		private String revisionId;
		private String activePerc;
		private String inactivePerc;
		private EntityReferenceData subItem;

		public SimpleDTOItemSpecificDimensions size(String size)
		{
			this.size = size;
			return this;
		}

		public SimpleDTOItemSpecificDimensions color(String color)
		{
			this.color = color;
			return this;
		}

		public SimpleDTOItemSpecificDimensions measures(String measures)
		{
			this.measures = measures;
			return this;
		}

		public SimpleDTOItemSpecificDimensions lotId(String lotId)
		{
			this.lotId = lotId;
			return this;
		}

		public SimpleDTOItemSpecificDimensions serialNumber(String serialNumber)
		{
			this.serialNumber = serialNumber;
			return this;
		}

		public SimpleDTOItemSpecificDimensions secondSerial(String secondSerial)
		{
			this.secondSerial = secondSerial;
			return this;
		}

		public SimpleDTOItemSpecificDimensions revisionId(String revisionId)
		{
			this.revisionId = revisionId;
			return this;
		}

		public SimpleDTOItemSpecificDimensions box(String box)
		{
			this.box = box;
			return this;
		}

		public SimpleDTOItemSpecificDimensions activePerc(String activePerc)
		{
			this.activePerc = activePerc;
			return this;
		}

		public SimpleDTOItemSpecificDimensions inactivePerc(String inactivePerc)
		{
			this.inactivePerc = inactivePerc;
			return this;
		}

		public SimpleDTOItemSpecificDimensions subItem(EntityReferenceData subItem)
		{
			this.subItem = subItem;
			return this;
		}

		@Override
		public String fetchSize()
		{
			return size;
		}

		@Override
		public String fetchColor()
		{
			return color;
		}

		@Override
		public String fetchMeasures()
		{
			return measures;
		}

		@Override
		public String fetchLotId()
		{
			return lotId;
		}

		@Override
		public String fetchSerialNumber()
		{
			return serialNumber;
		}

		@Override
		public String fetchSecondSerial()
		{
			return secondSerial;
		}

		@Override
		public String fetchBox()
		{
			return box;
		}

		@Override
		public String fetchRevisionId()
		{
			return revisionId;
		}

		@Override
		public String fetchActivePerc()
		{
			return activePerc;
		}

		@Override
		public String fetchInactivePerc()
		{
			return inactivePerc;
		}

		@Override
		public EntityReferenceData fetchSubItem()
		{
			return subItem;
		}
	}
}
