package com.namasoft.modules.commonbasic.contracts.requests.inv;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.requests.DTOBusinessRequest;
import com.namasoft.modules.commonbasic.contracts.requests.DTOInvTransReqList;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOACCSideConfig;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOInvEffectConfig;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOInvTransReq extends DTOBusinessRequest implements Serializable
{
	private Boolean compressed;
	private Boolean reFetchAccConfig;
	private Boolean regenerateLedgerReq;
	private Boolean reprocessStockAges;
	private Boolean useRWC;
	private DTOACCSideConfig additionalCostConfig;
	private DTOInvEffectConfig invEffectConfig;
	private DTOInvTransReqList list;
	private EntityReferenceData fromLegalEntity;
	private EntityReferenceData toLegalEntity;
	private Integer priority;
	private String costCallbackClass;
	private String costTransStatus;
	private String destDimensions;
	private String fifoLedgerTransReqId;
	private String invoiceId;
	private String qtyTransStatus;
	private String secondLevelSource;
	private String transferType;
	private String type;
	public Boolean getCompressed()
	{
		return compressed;
	}

	public Boolean getReFetchAccConfig()
	{
		return reFetchAccConfig;
	}

	public Boolean getRegenerateLedgerReq()
	{
		return regenerateLedgerReq;
	}

	public Boolean getReprocessStockAges()
	{
		return reprocessStockAges;
	}

	public Boolean getUseRWC()
	{
		return useRWC;
	}

	public DTOACCSideConfig getAdditionalCostConfig()
	{
		return additionalCostConfig;
	}

	public DTOInvEffectConfig getInvEffectConfig()
	{
		return invEffectConfig;
	}

	public DTOInvTransReqList getList()
	{
		return list;
	}

	public EntityReferenceData getFromLegalEntity()
	{
		return fromLegalEntity;
	}

	public EntityReferenceData getToLegalEntity()
	{
		return toLegalEntity;
	}

	public Integer getPriority()
	{
		return priority;
	}

	public String getCostCallbackClass()
	{
		return costCallbackClass;
	}

	public String getCostTransStatus()
	{
		return costTransStatus;
	}

	public String getDestDimensions()
	{
		return destDimensions;
	}

	public String getFifoLedgerTransReqId()
	{
		return fifoLedgerTransReqId;
	}

	public String getInvoiceId()
	{
		return invoiceId;
	}

	public String getQtyTransStatus()
	{
		return qtyTransStatus;
	}

	public String getSecondLevelSource()
	{
		return secondLevelSource;
	}

	public String getTransferType()
	{
		return transferType;
	}

	public String getType()
	{
		return type;
	}

	public void setAdditionalCostConfig(DTOACCSideConfig additionalCostConfig)
	{
		this.additionalCostConfig = additionalCostConfig;
	}

	public void setCompressed(Boolean compressed)
	{
		this.compressed = compressed;
	}

	public void setCostCallbackClass(String costCallbackClass)
	{
		this.costCallbackClass = costCallbackClass;
	}

	public void setCostTransStatus(String costTransStatus)
	{
		this.costTransStatus = costTransStatus;
	}

	public void setDestDimensions(String destDimensions)
	{
		this.destDimensions = destDimensions;
	}

	public void setFifoLedgerTransReqId(String fifoLedgerTransReqId)
	{
		this.fifoLedgerTransReqId = fifoLedgerTransReqId;
	}

	public void setFromLegalEntity(EntityReferenceData fromLegalEntity)
	{
		this.fromLegalEntity = fromLegalEntity;
	}

	public void setInvEffectConfig(DTOInvEffectConfig invEffectConfig)
	{
		this.invEffectConfig = invEffectConfig;
	}

	public void setInvoiceId(String invoiceId)
	{
		this.invoiceId = invoiceId;
	}

	public void setList(DTOInvTransReqList list)
	{
		this.list = list;
	}

	public void setPriority(Integer priority)
	{
		this.priority = priority;
	}

	public void setQtyTransStatus(String qtyTransStatus)
	{
		this.qtyTransStatus = qtyTransStatus;
	}

	public void setReFetchAccConfig(Boolean reFetchAccConfig)
	{
		this.reFetchAccConfig = reFetchAccConfig;
	}

	public void setRegenerateLedgerReq(Boolean regenerateLedgerReq)
	{
		this.regenerateLedgerReq = regenerateLedgerReq;
	}

	public void setReprocessStockAges(Boolean reprocessStockAges)
	{
		this.reprocessStockAges = reprocessStockAges;
	}

	public void setSecondLevelSource(String secondLevelSource)
	{
		this.secondLevelSource = secondLevelSource;
	}

	public void setToLegalEntity(EntityReferenceData toLegalEntity)
	{
		this.toLegalEntity = toLegalEntity;
	}

	public void setTransferType(String transferType)
	{
		this.transferType = transferType;
	}

	public void setType(String type)
	{
		this.type = type;
	}

	public void setUseRWC(Boolean useRWC)
	{
		this.useRWC = useRWC;
	}

}
