package com.namasoft.modules.commonbasic.contracts.requests.inv;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.requests.DTOBusinessRequestLine;
import com.namasoft.modules.commonbasic.contracts.requests.inv.DTOReqItemSpecificDimensions;
import com.namasoft.modules.commonbasic.contracts.requests.inv.DTOReqUserQuantity;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class GeneratedDTOInvTransReqLine extends DTOBusinessRequestLine implements Serializable
{
	private BigDecimal remaining;
	private BigDecimal totalCost;
	private BigDecimal unitCost;
	private Boolean inverse;
	private Boolean retunable;
	private DTOGenericDimensions genericDimensions;
	private DTOReqItemSpecificDimensions specificDimensions;
	private DTOReqUserQuantity quantity;
	private Date expiryDate;
	private Date productionDate;
	private EntityReferenceData item;
	private String customerId;
	private String invoiceId;
	private String invoiceType;
	private String remarks;
	private String supplierId;
	public BigDecimal getRemaining()
	{
		return remaining;
	}

	public BigDecimal getTotalCost()
	{
		return totalCost;
	}

	public BigDecimal getUnitCost()
	{
		return unitCost;
	}

	public Boolean getInverse()
	{
		return inverse;
	}

	public Boolean getRetunable()
	{
		return retunable;
	}

	public DTOGenericDimensions getGenericDimensions()
	{
		return genericDimensions;
	}

	public DTOReqItemSpecificDimensions getSpecificDimensions()
	{
		return specificDimensions;
	}

	public DTOReqUserQuantity getQuantity()
	{
		return quantity;
	}

	public Date getExpiryDate()
	{
		return expiryDate;
	}

	public Date getProductionDate()
	{
		return productionDate;
	}

	public EntityReferenceData getItem()
	{
		return item;
	}

	public String getCustomerId()
	{
		return customerId;
	}

	public String getInvoiceId()
	{
		return invoiceId;
	}

	public String getInvoiceType()
	{
		return invoiceType;
	}

	public String getRemarks()
	{
		return remarks;
	}

	public String getSupplierId()
	{
		return supplierId;
	}

	public void setCustomerId(String customerId)
	{
		this.customerId = customerId;
	}

	public void setExpiryDate(Date expiryDate)
	{
		this.expiryDate = expiryDate;
	}

	public void setGenericDimensions(DTOGenericDimensions genericDimensions)
	{
		this.genericDimensions = genericDimensions;
	}

	public void setInverse(Boolean inverse)
	{
		this.inverse = inverse;
	}

	public void setInvoiceId(String invoiceId)
	{
		this.invoiceId = invoiceId;
	}

	public void setInvoiceType(String invoiceType)
	{
		this.invoiceType = invoiceType;
	}

	public void setItem(EntityReferenceData item)
	{
		this.item = item;
	}

	public void setProductionDate(Date productionDate)
	{
		this.productionDate = productionDate;
	}

	public void setQuantity(DTOReqUserQuantity quantity)
	{
		this.quantity = quantity;
	}

	public void setRemaining(BigDecimal remaining)
	{
		this.remaining = remaining;
	}

	public void setRemarks(String remarks)
	{
		this.remarks = remarks;
	}

	public void setRetunable(Boolean retunable)
	{
		this.retunable = retunable;
	}

	public void setSpecificDimensions(DTOReqItemSpecificDimensions specificDimensions)
	{
		this.specificDimensions = specificDimensions;
	}

	public void setSupplierId(String supplierId)
	{
		this.supplierId = supplierId;
	}

	public void setTotalCost(BigDecimal totalCost)
	{
		this.totalCost = totalCost;
	}

	public void setUnitCost(BigDecimal unitCost)
	{
		this.unitCost = unitCost;
	}

}
