package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.modules.commonbasic.enums.CapabilityType;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.List;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class DTOAbstractStandardSecurityLine extends GeneratedDTOAbstractStandardSecurityLine implements Serializable
{
	public boolean userCan(String capabilityId)
	{
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Commit))
			return canCommit();
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.CreateDraft))
			return ObjectChecker.areEqual(getCanEdit(), EditAuthority.SaveDraft) || canCommit();
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.SaveDraft))
			return (ObjectChecker.areEqual(getCanEdit(), EditAuthority.SaveDraft) || canCommit()) && ObjectChecker.isFalseOrNull(
					getPreventSaveDraft());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Delete))
			return getCanDelete();
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.DeleteDraft))
		{
			if (ObjectChecker.areEqual("Yes", getDraftDeletionCapability()))
				return true;
			else if (ObjectChecker.areEqual("No", getDraftDeletionCapability()))
				return false;
			return getCanDelete();
		}
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.ChangeCapability))
			return ObjectChecker.isTrue(getCanChangeCapability()) || ObjectChecker.areEqual(getCanEdit(), EditAuthority.EditAfterCommit);
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.EditAfterCommit))
			return ObjectChecker.areEqual(getCanEdit(), EditAuthority.EditAfterCommit);
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.ListView))
			return getListView();
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.SearchView))
			return ObjectChecker.isAnyTrue(getSearchView(), getListView());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.PrintMoreThanOnce))
			return ObjectChecker.areEqual(getCanPrint(), PrintAuthority.MoreThanOne);
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.PrintOnce))
			return ObjectChecker.areEqual(getCanPrint(), PrintAuthority.One) || ObjectChecker.areEqual(getCanPrint(), PrintAuthority.MoreThanOne);
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.RecordView))
			return getRecordView();
		if(ObjectChecker.areEqual(capabilityId,CapabilityType.Export))
			return ObjectChecker.isTrue(getCanExport());
		if(ObjectChecker.areEqual(capabilityId,CapabilityType.Import))
			return ObjectChecker.isTrue(getCanImport());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Approve))
			return true;
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Revise))
			return ObjectChecker.isTrue(getCanRevise());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Unrevise))
			return ObjectChecker.isTrue(getCanUnRevise());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.Duplicate))
			return ObjectChecker.isTrue(getCanDuplicate());
		if (capabilityId.startsWith(CapabilityType.Revise.name()))
		{
			return canPerformOnLevel(capabilityId.replaceAll(CapabilityType.Revise.name(), ""), getReviseLevels(),
					ObjectChecker.isTrue(getCanRevise()));
		}
		else if (capabilityId.startsWith(CapabilityType.Unrevise.name()))
		{
			return canPerformOnLevel(capabilityId.replaceAll(CapabilityType.Unrevise.name(), ""), getUnreviseLevels(),
					ObjectChecker.isTrueOrNull(getCanUnRevise()));
		}
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.CanViewTransaction))
			return ObjectChecker.isFalseOrNull(getPreventViewSystemTransaction());
		if (ObjectChecker.areEqual(capabilityId, CapabilityType.CanViewMoreMenu))
			return ObjectChecker.isFalseOrNull(getPreventViewMoreMenu());
		return false;
	}

	private boolean canPerformOnLevel(String levelStr, String allowedLevels, boolean userCan)
	{
		if (!userCan)
			return false;
		if (ObjectChecker.isEmptyOrNull(allowedLevels))
			return true;
		Integer level = 0;
		if (ObjectChecker.isNotEmptyOrNull(levelStr))
			level = Integer.parseInt(levelStr.toUpperCase().replace("L", ""));
		String sep = ",";
		if (!allowedLevels.contains(sep))
			sep = "-";
		List<String> allowedLevelsList = StringUtils.csvLineToList(sep, allowedLevels.toUpperCase().replace("L", ""));
		for (String allowedLevelStr : allowedLevelsList)
		{
			Integer allowedLevel = Integer.parseInt(allowedLevelStr);
			if (ObjectChecker.areEqual(allowedLevel, level))
				return true;
		}
		return false;
	}

	private boolean canCommit()
	{
		return ObjectChecker.areEqual(getCanEdit(), EditAuthority.Commit) || ObjectChecker.areEqual(getCanEdit(), EditAuthority.EditAfterCommit);
	}

	public static DTOStandardSecurityLine of(CapabilityType recordview, String entityType)
	{
		DTOStandardSecurityLine standardSecurityLine = new DTOStandardSecurityLine();
		standardSecurityLine.setTargetEntity(entityType);
		return null;
	}

	public abstract String fetchTargetEntity();

	public abstract EntityReferenceData fetchTargetEntities();
}
