package com.namasoft.modules.commonbasic.contracts.valueobjects;

import java.io.Serializable;
import java.math.BigDecimal;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.utilities.NaMaMath;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.modules.commonbasic.enums.DiscountLocation;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOInvoiceLineMoney extends GeneratedDTOInvoiceLineMoney implements Serializable
{
	public DTOMoneyEffectDetails fetchDiscountEffect(DiscountLocation discount)
	{
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount1))
			return getDiscount1();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount2))
			return getDiscount2();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount3))
			return getDiscount3();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount4))
			return getDiscount4();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount5))
			return getDiscount5();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount6))
			return getDiscount6();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount7))
			return getDiscount7();
		if (ObjectChecker.areEqual(discount, DiscountLocation.Discount8))
			return getDiscount8();
		return null;
	}

	public void updateNulls()
	{
		if (getDiscount1() == null)
			setDiscount1(new DTOMoneyEffectDetails());
		if (getDiscount2() == null)
			setDiscount2(new DTOMoneyEffectDetails());
		if (getDiscount3() == null)
			setDiscount3(new DTOMoneyEffectDetails());
		if (getDiscount4() == null)
			setDiscount4(new DTOMoneyEffectDetails());
		if (getDiscount5() == null)
			setDiscount5(new DTOMoneyEffectDetails());
		if (getDiscount6() == null)
			setDiscount6(new DTOMoneyEffectDetails());
		if (getDiscount7() == null)
			setDiscount7(new DTOMoneyEffectDetails());
		if (getDiscount8() == null)
			setDiscount8(new DTOMoneyEffectDetails());
		if (getHeaderDicount() == null)
			setHeaderDicount(new DTOMoneyEffectDetails());
		if (getTax1() == null)
			setTax1(new DTOMoneyEffectDetails());
		if (getTax2() == null)
			setTax2(new DTOMoneyEffectDetails());
		if (getTax3() == null)
			setTax3(new DTOMoneyEffectDetails());
		if (getTax4() == null)
			setTax4(new DTOMoneyEffectDetails());
		getDiscount1().updateNulls();
		getDiscount2().updateNulls();
		getDiscount3().updateNulls();
		getDiscount4().updateNulls();
		getDiscount5().updateNulls();
		getDiscount6().updateNulls();
		getDiscount7().updateNulls();
		getDiscount8().updateNulls();
		getHeaderDicount().updateNulls();
		getTax1().updateNulls();
		getTax2().updateNulls();
		getTax3().updateNulls();
		getTax4().updateNulls();
		setUnitPrice(NaMaMath.zeroIfNull(getUnitPrice()));
	}

	public void resetMoney(boolean resetTaxes)
	{
		resetMoney(resetTaxes, true);
	}

	public void resetMoney(boolean resetTaxes, boolean resetPrices)
	{
		if (resetPrices)
			setUnitPrice(BigDecimal.ZERO);
		updateNulls();
		getDiscount1().resetMoney();
		getDiscount2().resetMoney();
		getDiscount3().resetMoney();
		getDiscount4().resetMoney();
		getDiscount5().resetMoney();
		getDiscount6().resetMoney();
		getDiscount7().resetMoney();
		getDiscount8().resetMoney();
		if (resetTaxes)
		{
			getTax1().resetMoney();
			getTax2().resetMoney();
			getTax3().resetMoney();
			getTax4().resetMoney();
		}
		if (resetPrices)
			setPrice(BigDecimal.ZERO);
		setNetValue(BigDecimal.ZERO);
	}

	public void updateTaxes(Integer currencyScale)
	{
		updateNulls();
		getTax1().updateTaxValueFromPercentages(getPrice(), currencyScale);
		getTax2().updateTaxValueFromPercentages(getPrice(), currencyScale);
		getTax3().updateTaxValueFromPercentages(getPrice(), currencyScale);
		getTax4().updateTaxValueFromPercentages(getPrice(), currencyScale);
	}

	public void updateTaxesPercentage(Integer percentageScale)
	{
		updateNulls();
		getTax1().updateTaxPercentage(getPrice(), percentageScale);
		getTax2().updateTaxPercentage(getPrice(), percentageScale);
		getTax3().updateTaxPercentage(getPrice(), percentageScale);
		getTax4().updateTaxPercentage(getPrice(), percentageScale);
	}

}
