package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.utilities.ObjectChecker;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOSecurityFieldAuthority extends GeneratedDTOSecurityFieldAuthority implements Serializable
{
	public static final String InVisible = "InVisible";
	public static final String Disabled = "Disabled";
	public static final String Normal = "Normal";
	public static final String NotDefined = "NotDefined";

	public static boolean shouldBeIgnored(String authority)
	{
		return ObjectChecker.isEmptyOrNull(authority) || ObjectChecker.areEqual(authority, NotDefined);
	}
}
