package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTODebtLineMatcher extends DTOLocalEntity implements Serializable
{
	private BigDecimal remainingCredit;
	private BigDecimal remainingDebit;
	private BigDecimal value;
	private Boolean isManual;
	private DTODebtLine creditLine;
	private DTODebtLine debitLine;
	private Date creditValueDate;
	private Date debitValueDate;
	private String ledgerReqId;
	private String manualEffectType;
	public BigDecimal getRemainingCredit()
	{
		return remainingCredit;
	}

	public BigDecimal getRemainingDebit()
	{
		return remainingDebit;
	}

	public BigDecimal getValue()
	{
		return value;
	}

	public Boolean getIsManual()
	{
		return isManual;
	}

	public DTODebtLine getCreditLine()
	{
		return creditLine;
	}

	public DTODebtLine getDebitLine()
	{
		return debitLine;
	}

	public Date getCreditValueDate()
	{
		return creditValueDate;
	}

	public Date getDebitValueDate()
	{
		return debitValueDate;
	}

	public String getLedgerReqId()
	{
		return ledgerReqId;
	}

	public String getManualEffectType()
	{
		return manualEffectType;
	}

	public void setCreditLine(DTODebtLine creditLine)
	{
		this.creditLine = creditLine;
	}

	public void setCreditValueDate(Date creditValueDate)
	{
		this.creditValueDate = creditValueDate;
	}

	public void setDebitLine(DTODebtLine debitLine)
	{
		this.debitLine = debitLine;
	}

	public void setDebitValueDate(Date debitValueDate)
	{
		this.debitValueDate = debitValueDate;
	}

	public void setIsManual(Boolean isManual)
	{
		this.isManual = isManual;
	}

	public void setLedgerReqId(String ledgerReqId)
	{
		this.ledgerReqId = ledgerReqId;
	}

	public void setManualEffectType(String manualEffectType)
	{
		this.manualEffectType = manualEffectType;
	}

	public void setRemainingCredit(BigDecimal remainingCredit)
	{
		this.remainingCredit = remainingCredit;
	}

	public void setRemainingDebit(BigDecimal remainingDebit)
	{
		this.remainingDebit = remainingDebit;
	}

	public void setValue(BigDecimal value)
	{
		this.value = value;
	}

}
