package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOInvEffectConfig implements Serializable
{
	private Boolean noAccountingEffect;
	private Boolean preventOverdraft;
	private Boolean returnable;
	private Boolean rwc;
	private Boolean shortenLedger;
	private DTOACCSideConfig credit;
	private DTOACCSideConfig debit;
	private EntityReferenceData additionalCostCredit;
	private EntityReferenceData additionalCostDebit;
	private EntityReferenceData purchaseRetDiffCredit;
	private EntityReferenceData purchaseRetDiffDebit;
	private String calcLedgerDateFrom;
	public Boolean getNoAccountingEffect()
	{
		return noAccountingEffect;
	}

	public Boolean getPreventOverdraft()
	{
		return preventOverdraft;
	}

	public Boolean getReturnable()
	{
		return returnable;
	}

	public Boolean getRwc()
	{
		return rwc;
	}

	public Boolean getShortenLedger()
	{
		return shortenLedger;
	}

	public DTOACCSideConfig getCredit()
	{
		return credit;
	}

	public DTOACCSideConfig getDebit()
	{
		return debit;
	}

	public EntityReferenceData getAdditionalCostCredit()
	{
		return additionalCostCredit;
	}

	public EntityReferenceData getAdditionalCostDebit()
	{
		return additionalCostDebit;
	}

	public EntityReferenceData getPurchaseRetDiffCredit()
	{
		return purchaseRetDiffCredit;
	}

	public EntityReferenceData getPurchaseRetDiffDebit()
	{
		return purchaseRetDiffDebit;
	}

	public String getCalcLedgerDateFrom()
	{
		return calcLedgerDateFrom;
	}

	public void setAdditionalCostCredit(EntityReferenceData additionalCostCredit)
	{
		this.additionalCostCredit = additionalCostCredit;
	}

	public void setAdditionalCostDebit(EntityReferenceData additionalCostDebit)
	{
		this.additionalCostDebit = additionalCostDebit;
	}

	public void setCalcLedgerDateFrom(String calcLedgerDateFrom)
	{
		this.calcLedgerDateFrom = calcLedgerDateFrom;
	}

	public void setCredit(DTOACCSideConfig credit)
	{
		this.credit = credit;
	}

	public void setDebit(DTOACCSideConfig debit)
	{
		this.debit = debit;
	}

	public void setNoAccountingEffect(Boolean noAccountingEffect)
	{
		this.noAccountingEffect = noAccountingEffect;
	}

	public void setPreventOverdraft(Boolean preventOverdraft)
	{
		this.preventOverdraft = preventOverdraft;
	}

	public void setPurchaseRetDiffCredit(EntityReferenceData purchaseRetDiffCredit)
	{
		this.purchaseRetDiffCredit = purchaseRetDiffCredit;
	}

	public void setPurchaseRetDiffDebit(EntityReferenceData purchaseRetDiffDebit)
	{
		this.purchaseRetDiffDebit = purchaseRetDiffDebit;
	}

	public void setReturnable(Boolean returnable)
	{
		this.returnable = returnable;
	}

	public void setRwc(Boolean rwc)
	{
		this.rwc = rwc;
	}

	public void setShortenLedger(Boolean shortenLedger)
	{
		this.shortenLedger = shortenLedger;
	}

}
