package com.namasoft.utils;

import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.contracts.common.dtos.BaseEntityDTO;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import com.namasoft.common.utils.translation.TranslationUtil;
import com.namasoft.common.utils.translation.TranslatorHelper;

public class DTOsTranslationHelper implements TranslatorHelper
{
	@Override
	public TranslationHelperResult translate(Language lang, Object arg)
	{
		if (arg == null)
		{
			return TranslationHelperResult.notHandled();
		}
		else if (arg instanceof EntityReferenceData)
		{
			return TranslationHelperResult.handled(ObjectChecker.toStringOrEmpty(TranslationUtil.getName(lang,
					((EntityReferenceData) arg).getName1(), ((EntityReferenceData) arg).getName2())));
		}
		else if (arg instanceof EntityReferenceData)
		{
			return TranslationHelperResult.handled(((EntityReferenceData) arg).getCode());
		}
		else if (arg instanceof MasterFileDTO)
		{
			return TranslationHelperResult.handled(ObjectChecker.toStringOrEmpty(TranslationUtil.getName(lang, ((MasterFileDTO) arg).getName1(),
					((MasterFileDTO) arg).getName2())));
		}
		else if (arg instanceof BaseEntityDTO)
		{
			return TranslationHelperResult.handled(((BaseEntityDTO) arg).getCode());
		}
		else if (arg instanceof Enum)
		{
			return TranslationHelperResult.handled(TranslationUtil.translate(lang, arg.getClass().getSimpleName() + "." + arg));
		}
		else if (arg instanceof NaMaText)
		{
			return TranslationHelperResult.handled(TranslationUtil.translate((NaMaText) arg, lang));
		}
		else
		{
			return TranslationHelperResult.notHandled();
		}
	}

	@Override
	public Language getCurrentLanguage()
	{
		return null;
	}

}
