package com.namasoft.utils;

import java.util.List;

import com.namasoft.common.ResultDTO;
import com.namasoft.common.constants.Language;
import com.namasoft.common.flatobjects.NaMaError;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utils.translation.TranslationUtil;

public class ServerSideExceptionDescriber
{
	public static NaMaText describeException(Exception e)
	{
		String ar = e.getMessage();
		String en = e.getMessage();
		if (e instanceof NaMaServiceExcepption)
		{
			ResultDTO result = ((NaMaServiceExcepption) e).getFaultInfo();
			if (result != null)
			{
				ar = describeResult(result, Language.Arabic);
				en = describeResult(result, Language.English);
			}
		}
		return NaMaText.text(ar, en);
	}

	public static String describeResult(ResultDTO result, Language lang)
	{
		String msg = "";
		List<NaMaError> errors = NaMaError.createErrorsForLeafResults(result);
		for (NaMaError error : errors)
		{
			msg += TranslationUtil.translate(error.getMessage(), lang) + "\n";
		}
		return msg;
	}
}
