/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingcommon.utils;

import com.namasoft.common.Pair;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.common.utilities.StringUtils;
import com.namasoft.printingcommon.utils.NamaPDFPageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.Orientation;

public class NamaPDFPrintUtil {
    private static NamaPDFPrintUtil instance;
    private String selectedPrinter;
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    public static PrintProgressListener printProgressListener;
    public static PrintLogListener printLogListener;
    private static int copiesCount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File downloadFile(HttpGet getRequest) {
        try (CloseableHttpResponse httpResponse = this.httpClient.execute((ClassicHttpRequest)getRequest);){
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity == null) {
                throw new RuntimeException("Error retrieving results from http request");
            }
            if (httpResponse.getCode() != 200) throw new RuntimeException("Error : " + ObjectChecker.toStringOrEmpty((Object)httpResponse.getEntity()));
            if (httpEntity.getContent() == null) throw new RuntimeException("Error : " + ObjectChecker.toStringOrEmpty((Object)httpResponse.getEntity()));
            File file = this.toFile(httpEntity.getContent());
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private File toFile(InputStream content) throws Exception {
        String fileName = "tempprint.jasperprint";
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        File tempFile = File.createTempFile(fileName, suffix);
        Files.copy(content, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return tempFile;
    }

    private HttpGet createGetRequest(String url, Map<String, String> headers, Map<String, String> params) {
        try {
            URIBuilder uriBuilder = new URIBuilder(url);
            uriBuilder.addParameters(this.getParametersAsList(params));
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            for (Map.Entry<String, String> header : headers.entrySet()) {
                httpGet.addHeader(header.getKey(), (Object)header.getValue());
            }
            return httpGet;
        }
        catch (Exception e) {
            throw new NaMaServiceExcepption((Throwable)e);
        }
    }

    private List<NameValuePair> getParametersAsList(Map<String, String> params) {
        ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                postParameters.add((NameValuePair)new BasicNameValuePair(key, params.get(key)));
            }
        }
        return postParameters;
    }

    public void printReports(Map<String, Object> body, Map<String, String> parameters, List<Pair<String, String>> tempPrintIdsWithPrinterName, List<String> errors) throws IOException, PrinterException {
        if (ObjectChecker.isEmptyOrNull(tempPrintIdsWithPrinterName)) {
            throw new RuntimeException("You must provide one temp id at least");
        }
        for (Pair<String, String> pair : tempPrintIdsWithPrinterName) {
            parameters.put("tempPrintId", (String)pair.getX());
            String url = ObjectChecker.toStringOrEmpty((Object)body.get("url"));
            if (!url.startsWith("http://") && !url.startsWith("https://")) {
                url = "http://".concat(url);
            }
            File pdfFile = this.downloadFile(this.createGetRequest(url + "/servqrep/exportTempIdToPDF", new HashMap<String, String>(), parameters));
            NamaPDFPrintUtil.instance().printReportToPrinter(pdfFile, (String)pair.getY(), errors, body);
        }
    }

    public static NamaPDFPrintUtil instance() {
        if (instance == null) {
            instance = new NamaPDFPrintUtil();
        }
        return instance;
    }

    public void updateSelectedPrinter(String selectedPrinter) {
        this.selectedPrinter = selectedPrinter;
    }

    public void printReportToPrinter(File pdfFile, String printerName, List<String> errors, Map<String, Object> body) throws IOException, PrinterException {
        if (pdfFile == null || !pdfFile.exists() || Files.size(pdfFile.toPath()) == 0L) {
            return;
        }
        String printer = (String)ObjectChecker.getFirstNotEmptyObj((Object[])new String[]{printerName, this.selectedPrinter});
        PDDocument document = Loader.loadPDF((File)pdfFile);
        PrintService selectedService = this.getPrintService(printer);
        if (selectedService == null) {
            errors.add("Could not find a printer with the name " + printerName);
            return;
        }
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintService(selectedService);
        job.setPageable(new NamaPDFPageable(document, Orientation.AUTO, job.defaultPage()));
        job.print();
        ++copiesCount;
        if (printProgressListener != null) {
            printProgressListener.updateProgress(copiesCount);
        }
        document.close();
    }

    public void logPrintOperation(Map<String, Object> body, boolean success) {
        if (printLogListener != null) {
            printLogListener.updateLog(body, success);
        }
    }

    private PrintService getPrintService(String printerName) {
        if (ObjectChecker.isEmptyOrNull((Object)printerName)) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
        for (PrintService printer : this.availablePrinters()) {
            if (!StringUtils.isAnyEqualIgnoreCaseToFirst((String)printer.getName(), (String[])new String[]{printerName})) continue;
            return printer;
        }
        if (printerName.contains(",")) {
            String[] names = printerName.split(",");
            for (PrintService printer : this.availablePrinters()) {
                if (!StringUtils.isAnyEqualIgnoreCaseToFirst((String)printer.getName(), (String[])names)) continue;
                return printer;
            }
        }
        return null;
    }

    public PrintService defaultPrinter() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public List<PrintService> availablePrinters() {
        return CollectionsUtility.asList((Object[])PrintServiceLookup.lookupPrintServices(null, null));
    }

    static {
        printProgressListener = null;
        printLogListener = null;
        copiesCount = 0;
    }

    public static interface PrintProgressListener {
        public void updateProgress(int var1);
    }

    public static interface PrintLogListener {
        public void updateLog(Map<String, Object> var1, boolean var2);
    }
}

