/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingserver;

import com.namasoft.common.constants.PlaceTokens;
import com.namasoft.common.constants.ViewMode;
import com.namasoft.common.utilities.CollectionsUtility;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.printingcommon.utils.NamaPDFPrintUtil;
import com.namasoft.printingserver.PrintLogEntry;
import com.namasoft.printingserver.PrinterServerEntryPoint;
import com.namasoft.printingserver.utils.SerialPortConfig;
import com.namasoft.printingserver.utils.WeightScaleConnector;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javax.print.PrintService;

public class HomeScreen
extends BorderPane {
    private static HomeScreen instance;
    private final ComboBox<String> printers;
    private final ComboBox<String> serialPorts;
    private final Button hideInTray;
    private final TextField selectedPrinter;
    private final TextField selectedSerialPort;
    private final TextArea progressMessageArea;
    private final ListView<PrintLogEntry> logListView;

    public static HomeScreen instance(PrinterServerEntryPoint entryPoint) {
        if (instance == null) {
            instance = new HomeScreen(entryPoint);
        }
        return instance;
    }

    private HomeScreen(PrinterServerEntryPoint entryPoint) {
        NamaPDFPrintUtil.printProgressListener = HomeScreen::updateProgress;
        NamaPDFPrintUtil.printLogListener = HomeScreen::updateLog;
        GridPane grid = new GridPane();
        grid.setHgap(20.0);
        grid.setVgap(20.0);
        VBox vBox = new VBox(40.0);
        this.printers = new ComboBox();
        this.serialPorts = new ComboBox();
        this.selectedPrinter = new TextField();
        this.selectedSerialPort = new TextField();
        this.progressMessageArea = new TextArea();
        this.logListView = new ListView();
        this.hideInTray = new Button("Hide In Tray");
        this.hideInTray.setOnAction(e -> entryPoint.hideApp());
        Label printersLabel = new Label("Please Select Printer");
        Label serialPortsLabel = new Label("Please Select Serial Port (Weight Scale APP)");
        Label selectedPrinterLabel = new Label("Selected Printer");
        Label selectedSerialPortLabel = new Label("Selected Serial Port (Weight Scale APP)");
        Label progressMessageLabel = new Label("Progress Message");
        PrintService printer = NamaPDFPrintUtil.instance().defaultPrinter();
        ArrayList<String> list = new ArrayList<String>();
        if (printer != null) {
            list.add(printer.getName());
        }
        list.addAll(NamaPDFPrintUtil.instance().availablePrinters().stream().map(PrintService::getName).filter(name -> printer == null || ObjectChecker.areNotEqual((Object)printer.getName(), (Object)name)).collect(Collectors.toList()));
        this.printers.getItems().addAll(list);
        this.printers.setValue((Object)((String)CollectionsUtility.getFirst(list)));
        this.selectedPrinter.setText((String)this.printers.getValue());
        this.printers.setOnAction(e -> {
            NamaPDFPrintUtil.instance().updateSelectedPrinter((String)this.printers.getSelectionModel().getSelectedItem());
            this.selectedPrinter.setText((String)this.printers.getSelectionModel().getSelectedItem());
        });
        Object[] availablePorts = WeightScaleConnector.getAvailablePorts();
        this.serialPorts.getItems().addAll(availablePorts);
        String savedPort = SerialPortConfig.loadSelectedPort();
        if (this.serialPorts.getItems().contains((Object)savedPort)) {
            this.serialPorts.setValue((Object)savedPort);
        } else if (availablePorts.length > 0) {
            this.serialPorts.setValue(availablePorts[0]);
        }
        this.selectedSerialPort.setText((String)this.serialPorts.getValue());
        this.serialPorts.setOnAction(e -> {
            String selectedPort = (String)this.serialPorts.getSelectionModel().getSelectedItem();
            SerialPortConfig.saveSelectedPort(selectedPort);
            this.selectedSerialPort.setText(selectedPort);
            WeightScaleConnector.close();
            WeightScaleConnector.open(selectedPort);
        });
        grid.add((Node)printersLabel, 0, 0);
        grid.add(this.printers, 1, 0);
        grid.add((Node)selectedPrinterLabel, 0, 1);
        grid.add((Node)this.selectedPrinter, 1, 1);
        grid.add((Node)serialPortsLabel, 0, 2);
        grid.add(this.serialPorts, 1, 2);
        grid.add((Node)selectedSerialPortLabel, 0, 3);
        grid.add((Node)this.selectedSerialPort, 1, 3);
        grid.add((Node)progressMessageLabel, 0, 4);
        grid.add((Node)this.progressMessageArea, 1, 4);
        grid.setAlignment(Pos.CENTER);
        vBox.getChildren().addAll((Object[])new Node[]{grid, this.hideInTray});
        vBox.setAlignment(Pos.CENTER);
        this.setCenter((Node)vBox);
        this.logListView.setCellFactory(param -> new ListCell<PrintLogEntry>(this){

            protected void updateItem(PrintLogEntry item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty || item == null) {
                    this.setText(null);
                    this.setStyle("");
                } else {
                    this.setText(item.toString());
                    if (item.isSuccess()) {
                        this.setStyle("-fx-background-color: #2ecc71;");
                    } else {
                        this.setStyle("-fx-background-color: #dc3545;");
                    }
                }
            }
        });
        this.logListView.setOnMouseClicked(event -> {
            if (this.logListView.getSelectionModel().isEmpty()) {
                return;
            }
            PrintLogEntry selectedItem = (PrintLogEntry)this.logListView.getSelectionModel().getSelectedItem();
            try {
                Desktop.getDesktop().browse(new URI(selectedItem.getFromUrl() + PlaceTokens.getEditPlaceToken((String)selectedItem.getEntityType(), (String)selectedItem.getEntityId(), (ViewMode)ViewMode.EDIT)));
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.logListView.getSelectionModel().clearSelection();
        });
        this.setBottom((Node)this.logListView);
    }

    public static void updateProgress(int totalPrintedCount) {
        if (instance == null) {
            return;
        }
        Platform.runLater(() -> HomeScreen.instance.progressMessageArea.setText("Successfully printed " + totalPrintedCount + " copies"));
    }

    public static void updateLog(Map<String, Object> requestBody, boolean success) {
        if (instance == null) {
            return;
        }
        Platform.runLater(() -> {
            List printParams = (List)requestBody.get("printParams");
            if (ObjectChecker.isEmptyOrNull((Object)printParams)) {
                return;
            }
            for (Map printParam : printParams) {
                PrintLogEntry e = new PrintLogEntry();
                e.setEntityType(ObjectChecker.toStringOrEmpty(printParam.get("entityType")));
                e.setEntityCode(ObjectChecker.toStringOrEmpty(printParam.get("entityCode")));
                e.setEntityId(ObjectChecker.toStringOrEmpty(printParam.get("entityId")));
                e.setFromUrl(ObjectChecker.toStringOrEmpty(requestBody.get("url")));
                e.setSuccess(success);
                if (HomeScreen.instance.logListView.getItems().size() > 100) {
                    HomeScreen.instance.logListView.getItems().remove(0, 50);
                }
                HomeScreen.instance.logListView.getItems().add((Object)e);
            }
            HomeScreen.instance.logListView.scrollTo(HomeScreen.instance.logListView.getItems().size() - 1);
        });
    }
}

