/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingserver;

import com.dustinredmond.fxtrayicon.FXTrayIcon;
import com.namasoft.common.utilities.LoggingConfigurator;
import com.namasoft.printingserver.HomeScreen;
import com.namasoft.printingserver.utils.SerialPortConfig;
import com.namasoft.printingserver.utils.WeightScaleConnector;
import java.util.Collections;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuItem;
import javafx.scene.image.Image;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(value={"com.namasoft.printingserver.conrtollers"})
public class PrinterServerEntryPoint
extends Application {
    private Stage stage;
    private MenuItem hideItem;
    private FXTrayIcon trayIcon;
    private MenuItem showItem;
    private MenuItem exitItem;

    public void start(Stage primaryStage) throws Exception {
        this.doSetUp();
        this.stage = primaryStage;
        System.setProperty("java.awt.headless", "false");
        this.showItem = new MenuItem("Show");
        this.hideItem = new MenuItem("Hide");
        this.exitItem = new MenuItem("Exit");
        this.trayIcon = new FXTrayIcon(primaryStage, ((Object)((Object)this)).getClass().getResource("/images/app_icon.png"));
        this.trayIcon.setTrayIconTooltip("Nama Printer");
        this.trayIcon.setApplicationTitle("Nama Printer");
        this.trayIcon.addMenuItem(this.hideItem);
        this.trayIcon.addMenuItem(this.exitItem);
        this.trayIcon.show();
        this.showItem.setOnAction(e -> this.showApp());
        this.hideItem.setOnAction(e -> this.hideApp());
        this.exitItem.setOnAction(e -> this.closeApp());
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        Scene scene = new Scene((Parent)HomeScreen.instance(this), screenBounds.getWidth(), screenBounds.getHeight());
        scene.setNodeOrientation(NodeOrientation.LEFT_TO_RIGHT);
        primaryStage.setScene(scene);
        primaryStage.setTitle("Printer Server");
        primaryStage.setMaximized(true);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/main.css").toExternalForm());
        primaryStage.show();
        primaryStage.getIcons().add((Object)new Image("/images/app_icon.png"));
        primaryStage.setOnCloseRequest(e -> this.closeApp());
    }

    private void showApp() {
        Platform.runLater(() -> {
            this.trayIcon.clear();
            this.trayIcon.addMenuItem(this.hideItem);
            this.trayIcon.addMenuItem(this.exitItem);
            this.stage.show();
        });
    }

    public void hideApp() {
        Platform.runLater(() -> {
            this.trayIcon.clear();
            this.trayIcon.addMenuItem(this.showItem);
            this.trayIcon.addMenuItem(this.exitItem);
            this.stage.hide();
        });
    }

    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(new Class[]{PrinterServerEntryPoint.class});
        app.setDefaultProperties(Collections.singletonMap("server.port", "9494"));
        app.run(args);
        String savedPort = SerialPortConfig.loadSelectedPort();
        WeightScaleConnector.open(savedPort);
        PrinterServerEntryPoint.launch((String[])args);
    }

    private void doSetUp() {
        LoggingConfigurator.configureUsingCode((boolean)false);
    }

    private void closeApp() {
        WeightScaleConnector.close();
        System.exit(0);
        Platform.exit();
    }
}

