/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingserver.conrtollers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import com.namasoft.printingcommon.utils.NamaPDFPrintUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PrintController {
    @CrossOrigin
    @PostMapping(value={"/print"}, consumes={"application/json;charset=UTF-8"})
    public String print(@RequestBody Map<String, Object> body) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        List<String> serverParameters = Arrays.asList("tempPrintId", "fileName", "user", "pass");
        ArrayList<Pair<String, String>> tempPrintIdsWithPrinterName = new ArrayList<Pair<String, String>>();
        this.handleQueueAppRequest(tempPrintIdsWithPrinterName, body);
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            if (!serverParameters.contains(entry.getKey()) || ObjectChecker.isEmptyOrNull((Object)entry.getValue())) continue;
            parameters.put(entry.getKey(), ObjectChecker.toStringOrEmpty((Object)entry.getValue()));
        }
        ArrayList errors = new ArrayList();
        NamaPDFPrintUtil.instance().printReports(body, parameters, tempPrintIdsWithPrinterName, errors);
        return errors.isEmpty() ? "done" : String.join((CharSequence)"\n", errors);
    }

    @CrossOrigin
    @PostMapping(value={"/namaPrint"})
    public String namaPrint(@RequestBody String test) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Map body = (Map)new ObjectMapper().readValue(test, Map.class);
        ArrayList errors = new ArrayList();
        boolean success = false;
        try {
            ArrayList<Pair<String, String>> tempPrintIdsWithPrinterName = new ArrayList<Pair<String, String>>();
            this.handleNamaRequest(tempPrintIdsWithPrinterName, body);
            for (Map.Entry entry : body.entrySet()) {
                if (ObjectChecker.isEmptyOrNull(entry.getValue())) continue;
                parameters.put((String)entry.getKey(), ObjectChecker.toStringOrEmpty(entry.getValue()));
            }
            NamaPDFPrintUtil.instance().printReports(body, parameters, tempPrintIdsWithPrinterName, errors);
            success = errors.isEmpty();
            NamaPDFPrintUtil.instance().logPrintOperation(body, success);
        }
        catch (Exception e) {
            NamaPDFPrintUtil.instance().logPrintOperation(body, false);
        }
        return success ? "done" : String.join((CharSequence)"\n", errors);
    }

    private void handleNamaRequest(List<Pair<String, String>> tempPrintIdsWithPrinterName, Map<String, Object> body) {
        Object printParams = body.get("printParams");
        if (!(printParams instanceof List)) {
            return;
        }
        List params = (List)printParams;
        for (Map param : params) {
            if (ObjectChecker.isEmptyOrNull(param.get("tempPrintId"))) {
                return;
            }
            tempPrintIdsWithPrinterName.add((Pair<String, String>)new Pair((Object)((String)param.get("tempPrintId")), (Object)((String)param.get("printerName"))));
        }
    }

    private void handleQueueAppRequest(List<Pair<String, String>> tempPrintIdsWithPrinterName, Map<String, Object> body) {
        Object tempPrintId = body.get("tempPrintId");
        if (ObjectChecker.isEmptyOrNull((Object)tempPrintId)) {
            return;
        }
        tempPrintIdsWithPrinterName.add((Pair<String, String>)new Pair((Object)ObjectChecker.toStringOrEmpty((Object)tempPrintId), null));
    }
}

