/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingserver.utils;

import com.namasoft.common.utilities.NaMaLogger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;

public class SerialPortConfig {
    private static final String CONFIG_FILE = "serial-port-config.properties";
    private static final String PORT_NAME_KEY = "selected.port";
    private static final String DEFAULT_PORT = "";

    public static String loadSelectedPort() {
        String string;
        Path configPath = Paths.get(CONFIG_FILE, new String[0]);
        if (!Files.exists(configPath, new LinkOption[0])) {
            NaMaLogger.info((String)"No serial port configuration found, using default: {0}", (Object[])new Object[]{DEFAULT_PORT});
            return DEFAULT_PORT;
        }
        FileInputStream input = new FileInputStream(CONFIG_FILE);
        try {
            Properties properties = new Properties();
            properties.load(input);
            String port = properties.getProperty(PORT_NAME_KEY, DEFAULT_PORT);
            NaMaLogger.info((String)"Loaded serial port configuration: {0}", (Object[])new Object[]{port});
            string = port;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                NaMaLogger.error((String)"Error loading serial port configuration: {0}", (Object[])new Object[]{e.getMessage()});
                return DEFAULT_PORT;
            }
        }
        ((InputStream)input).close();
        return string;
    }

    public static void saveSelectedPort(String portName) {
        try (FileOutputStream output = new FileOutputStream(CONFIG_FILE);){
            Properties properties = new Properties();
            properties.setProperty(PORT_NAME_KEY, portName);
            properties.store(output, "Serial Port Configuration");
            NaMaLogger.info((String)"Saved serial port configuration: {0}", (Object[])new Object[]{portName});
        }
        catch (IOException e) {
            NaMaLogger.error((String)"Error saving serial port configuration: {0}", (Object[])new Object[]{e.getMessage()});
        }
    }
}

