/*
 * Decompiled with CFR 0.152.
 */
package com.namasoft.printingserver.utils;

import com.namasoft.common.utilities.NaMaLogger;
import com.namasoft.common.utilities.ObjectChecker;
import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class WeightScaleConnector {
    private static SerialPort serialPort;

    public static String[] getAvailablePorts() {
        return SerialPortList.getPortNames();
    }

    public static void open(String portName) {
        if (ObjectChecker.isEmptyOrNull((Object)portName)) {
            return;
        }
        try {
            serialPort = new SerialPort(portName);
            NaMaLogger.info((String)"Current Active COMM Port is {0}", (Object[])new Object[]{serialPort.getPortName()});
            serialPort.openPort();
            serialPort.setParams(9600, 8, 1, 0);
        }
        catch (SerialPortException e) {
            NaMaLogger.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static String read() {
        NaMaLogger.info((String)"Read from {0}  ", (Object[])new Object[]{serialPort.getPortName()});
        try {
            serialPort.writeString("P\r\n");
            Thread.sleep(300L);
            String data = serialPort.readString();
            if (data != null) {
                NaMaLogger.info((Object)("Raw data: " + data.trim()));
                return WeightScaleConnector.parseWeight(data);
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
            throw new RuntimeException(e);
        }
        return "";
    }

    private static String parseWeight(String data) {
        return (data = data.replaceAll("[^0-9.\\-]", "")).isEmpty() ? null : data;
    }

    public static void close() {
        try {
            if (serialPort != null) {
                serialPort.closePort();
            }
        }
        catch (Exception e) {
            NaMaLogger.error((Throwable)e);
        }
    }
}

