/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail.resolver;

import jakarta.activation.DataSource;
import jakarta.activation.FileTypeMap;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.mail.resolver.DataSourceBaseResolver;

public class DataSourceClassPathResolver
extends DataSourceBaseResolver {
    private final String classPathBase;

    public DataSourceClassPathResolver() {
        this.classPathBase = "/";
    }

    public DataSourceClassPathResolver(String classPathBase) {
        this.classPathBase = classPathBase.endsWith("/") ? classPathBase : classPathBase + "/";
    }

    public DataSourceClassPathResolver(String classPathBase, boolean lenient) {
        super(lenient);
        this.classPathBase = classPathBase.endsWith("/") ? classPathBase : classPathBase + "/";
    }

    public String getClassPathBase() {
        return this.classPathBase;
    }

    @Override
    public DataSource resolve(String resourceLocation) throws IOException {
        return this.resolve(resourceLocation, this.isLenient());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
        try {
            if (this.isCid(resourceLocation)) return null;
            if (this.isHttpUrl(resourceLocation)) return null;
            String mimeType = FileTypeMap.getDefaultFileTypeMap().getContentType(resourceLocation);
            String resourceName = this.getResourceName(resourceLocation);
            try (InputStream is = DataSourceClassPathResolver.class.getResourceAsStream(resourceName);){
                if (is == null) {
                    if (!isLenient) throw new IOException("The following class path resource was not found : " + resourceLocation);
                    DataSource dataSource = null;
                    return dataSource;
                }
                ByteArrayDataSource ds = new ByteArrayDataSource(is, mimeType);
                ds.setName(DataSourceClassPathResolver.class.getResource(resourceName).toString());
                ByteArrayDataSource byteArrayDataSource = ds;
                return byteArrayDataSource;
            }
        }
        catch (IOException e) {
            if (!isLenient) throw e;
            return null;
        }
    }

    private String getResourceName(String resourceLocation) {
        return (this.getClassPathBase() + resourceLocation).replace("//", "/");
    }
}

