package com.namasoft.contracts.common.dtos;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.GwtIncompatible;
import com.namasoft.common.GwtTransient;
import com.namasoft.common.objects.DTOFileAttachmentInfo;

import jakarta.activation.DataHandler;
import jakarta.xml.bind.annotation.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOLargeData extends DTOLargeDataWithoutAttachment
{
	@GwtIncompatible(value = "F")
	@GwtTransient
	@JsonIgnore
	private DataHandler data;

	@GwtIncompatible(value = "F")
	@XmlMimeType("application/octet-stream")
	public DataHandler getData()
	{
		return data;
	}

	@GwtIncompatible(value = "F")
	public void setData(DataHandler data)
	{
		this.data = data;
	}

	public DTOLargeData()
	{

	}

	public DTOLargeData(DTOFileAttachmentInfo attachmentInfo)
	{
		setAttachmentInfo(attachmentInfo);
	}
}
