package com.namasoft.contracts.common.dtos;

import com.namasoft.common.NaMaDTO;
import jakarta.xml.bind.annotation.*;

import java.math.BigDecimal;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOTransactionMoney extends NaMaDTO
{
	private DTOMoney value;
	private BigDecimal rate;
	private BigDecimal localAmount;

	public DTOMoney getValue()
	{
		return value;
	}

	public void setValue(DTOMoney value)
	{
		this.value = value;
	}

	public BigDecimal getRate()
	{
		return rate;
	}

	public void setRate(BigDecimal rate)
	{
		this.rate = rate;
	}

	public BigDecimal getLocalAmount()
	{
		return localAmount;
	}

	public void setLocalAmount(BigDecimal localAmount)
	{
		this.localAmount = localAmount;
	}

	public void updateNulls()
	{
		if (getLocalAmount() == null)
		{
			setLocalAmount(BigDecimal.ZERO);
		}
		if (getRate() == null)
		{
			setRate(BigDecimal.ONE);
		}
		DTOMoney money = getValue();
		if (money == null)
		{
			money = new DTOMoney();
			setValue(money);
		}
		if (money.getAmount() == null)
		{
			money.setAmount(BigDecimal.ZERO);
		}
	}

	public DTOTransactionMoney cloneData()
	{
		updateNulls();
		DTOTransactionMoney money = new DTOTransactionMoney();
		money.setLocalAmount(getLocalAmount());
		money.setRate(getRate());
		money.setValue(new DTOMoney());
		money.getValue().setAmount(getValue().getAmount());
		money.getValue().setCurrency(getValue().getCurrency());
		return money;
	}

}
