package com.namasoft.contracts.common.dtos.requests;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.contracts.common.dtos.DTOLargeData;

import jakarta.xml.bind.annotation.*;
import java.util.*;

@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
@SuppressWarnings("serial")
public class ApproveRequest extends EntityServiceRequest
{

	private String entityId;
	private String approverId;
	private String decision;
	private String comment;
	private List<String> fieldIds;
	private List<String> fieldValues;
	private String approvedLines;
	private Long stepSequence;
	private String approvalReasonIdOrCode;
	private EntityReferenceData escalateTo;
	private String otp;
	private DTOLargeData attachment;
	public ApproveRequest()
	{
		super();
		this.fieldIds = new ArrayList<>();
		this.fieldValues = new ArrayList<>();
	}

	public ApproveRequest(String entityType, String entityId, String approver, String decision, String comment, Long stepSequence,
			String approvedIndices, String approvalReasonIdOrCode, DTOFileAttachmentInfo attachmentInfo, EntityReferenceData escalateTo, String otp)
	{
		super(entityType);
		this.entityId = entityId;
		this.approverId = approver;
		this.decision = decision;
		this.escalateTo = escalateTo;
		this.otp = otp;
		this.comment = comment;
		this.stepSequence = stepSequence;
		this.fieldIds = new ArrayList<>();
		this.fieldValues = new ArrayList<>();
		this.approvedLines = approvedIndices;
		this.approvalReasonIdOrCode = approvalReasonIdOrCode;
		if (attachmentInfo != null)
		{
			this.attachment = new DTOLargeData();
			this.attachment.setAttachmentInfo(attachmentInfo);
		}
	}

	public String getOtp()
	{
		return otp;
	}

	public void setOtp(String otp)
	{
		this.otp = otp;
	}

	public EntityReferenceData getEscalateTo()
	{
		return escalateTo;
	}

	public void setEscalateTo(EntityReferenceData escalateTo)
	{
		this.escalateTo = escalateTo;
	}

	public String getEntityId()
	{
		return entityId;
	}

	public void setEntityId(String entityId)
	{
		this.entityId = entityId;
	}

	public String getApproverId()
	{
		return approverId;
	}

	public void setApproverId(String approver)
	{
		this.approverId = approver;
	}

	public String getDecision()
	{
		return decision;
	}

	public void setDecision(String decision)
	{
		this.decision = decision;
	}

	public String getComment()
	{
		return comment;
	}

	public void setComment(String comment)
	{
		this.comment = comment;
	}

	public Long getStepSequence()
	{
		return stepSequence;
	}

	public void setStepSequence(Long stepSequence)
	{
		this.stepSequence = stepSequence;
	}

	public List<String> getFieldIds()
	{
		return fieldIds;
	}

	public void setFieldIds(List<String> fieldIds)
	{
		this.fieldIds = fieldIds;
	}

	public List<String> getFieldValues()
	{
		return fieldValues;
	}

	public void setFieldValues(List<String> fieldValues)
	{
		this.fieldValues = fieldValues;
	}

	public String getApprovedLines()
	{
		return approvedLines;
	}

	public void setApprovedLines(String approvedLines)
	{
		this.approvedLines = approvedLines;
	}

	public String getApprovalReasonIdOrCode()
	{
		return approvalReasonIdOrCode;
	}

	public void setApprovalReasonIdOrCode(String approvalReasonIdOrCode)
	{
		this.approvalReasonIdOrCode = approvalReasonIdOrCode;
	}

	public DTOLargeData getAttachment()
	{
		return attachment;
	}

	public void setAttachment(DTOLargeData attachment)
	{
		this.attachment = attachment;
	}
}
