package com.namasoft.contracts.common.dtos.requests;

import jakarta.activation.DataHandler;
import jakarta.xml.bind.annotation.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
@XmlRootElement
public class ChangePasswordRequest extends ServiceRequest
{
	/**
	 * 
	 */
	private static final long serialVersionUID = 5007451747264820529L;
	private String userIdToChangePasswordFor;
	private String newPassword;
	private String confirmPassword;
	private Boolean passwordMustBeChanged;
	private Boolean notifyBySMS;
	private Boolean notifyByEmail;
	private String userEmail;
	private String emailPassword;
	private DataHandler imageData;
	private String imageName;
	private String mobileNumber;
	private Boolean removeImage;

	public Boolean getNotifyBySMS()
	{
		return notifyBySMS;
	}

	public void setNotifyBySMS(Boolean notifyBySMS)
	{
		this.notifyBySMS = notifyBySMS;
	}

	public Boolean getNotifyByEmail()
	{
		return notifyByEmail;
	}

	public void setNotifyByEmail(Boolean notifyByEmail)
	{
		this.notifyByEmail = notifyByEmail;
	}

	public ChangePasswordRequest()
	{
		super();
	}

	public ChangePasswordRequest(String userIdToChangePasswordFor, String newPassword, String confirmPassword, Boolean passwordMustBeChanged)
	{
		super();
		this.userIdToChangePasswordFor = userIdToChangePasswordFor;
		this.newPassword = newPassword;
		this.confirmPassword = confirmPassword;
		this.passwordMustBeChanged = passwordMustBeChanged;
	}

	public ChangePasswordRequest(String userIdToChangePasswordFor, String newPassword, String confirmPassword,String userEmail, String emailPassword, Boolean passwordMustBeChanged,
			Boolean notifyByEmail, Boolean notifyBySMS, DataHandler imageData, String imageName, String mobileNumber, Boolean removeImage)
	{
		super();
		this.userIdToChangePasswordFor = userIdToChangePasswordFor;
		this.newPassword = newPassword;
		this.confirmPassword = confirmPassword;
		this.passwordMustBeChanged = passwordMustBeChanged;
		this.notifyBySMS = notifyBySMS;
		this.notifyByEmail = notifyByEmail;
		this.userEmail = userEmail;
		this.emailPassword = emailPassword;
		this.imageData = imageData;
		this.imageName = imageName;
		this.mobileNumber = mobileNumber;
		this.removeImage = removeImage;
	}

	public String getUserIdToChangePasswordFor()
	{
		return userIdToChangePasswordFor;
	}

	public void setUserIdToChangePasswordFor(String userIdToChangePasswordFor)
	{
		this.userIdToChangePasswordFor = userIdToChangePasswordFor;
	}

	public String getNewPassword()
	{
		return newPassword;
	}

	public void setNewPassword(String newPassword)
	{
		this.newPassword = newPassword;
	}

	public String getConfirmPassword()
	{
		return confirmPassword;
	}

	public void setConfirmPassword(String confirmPassword)
	{
		this.confirmPassword = confirmPassword;
	}

	public Boolean getPasswordMustBeChanged()
	{
		return passwordMustBeChanged;
	}

	public void setPasswordMustBeChanged(Boolean passwordMustBeChanged)
	{
		this.passwordMustBeChanged = passwordMustBeChanged;
	}
	public String getUserEmail()
	{
		return userEmail;
	}

	public void setUserEmail(String userEmail)
	{
		this.userEmail = userEmail;
	}

	public String getEmailPassword()
	{
		return emailPassword;
	}

	public void setEmailPassword(String emailPassword)
	{
		this.emailPassword = emailPassword;
	}

	@XmlMimeType("application/octet-stream")
	public DataHandler getImageData()
	{
		return imageData;
	}

	public void setImageData(DataHandler imageData)
	{
		this.imageData = imageData;
	}

	public String getImageName()
	{
		return imageName;
	}

	public void setImageName(String imageName)
	{
		this.imageName = imageName;
	}

	public String getMobileNumber()
	{
		return mobileNumber;
	}

	public void setMobileNumber(String mobileNumber)
	{
		this.mobileNumber = mobileNumber;
	}

	public Boolean isRemoveImage()
	{
		return removeImage;
	}

	public void setRemoveImage(Boolean removeImage)
	{
		this.removeImage = removeImage;
	}
}
