package com.namasoft.contracts.common.services;

import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;

import com.namasoft.contracts.common.dtos.requests.AccountBalanceRequest;
import com.namasoft.contracts.common.dtos.requests.SendRequest;
import com.namasoft.contracts.common.dtos.results.GetResult;
import com.namasoft.contracts.common.dtos.results.ListResult;
import com.namasoft.common.exceptions.NaMaServiceExcepption;
import com.namasoft.contracts.common.services.base.NaMaUtilityWS;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOAccountBalanceResult;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOBudgetCalculationRequest;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOBudgetCalculationResult;

@WebService(name = "accountbalanceutilityws")
public interface AccountBalanceUtilityWS extends NaMaUtilityWS
{
	@WebMethod
	GetResult<DTOAccountBalanceResult> getAccBalanceFromDimensionsBalance(@WebParam(name = "request") SendRequest<AccountBalanceRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOAccountBalanceResult> getAccBalanceFromLedgerTransLines(@WebParam(name = "request") SendRequest<AccountBalanceRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ListResult<DTOBudgetCalculationResult> getListOfAccBalance(@WebParam(name = "request") SendRequest<DTOBudgetCalculationRequest> request)
			throws NaMaServiceExcepption;

}
