package com.namasoft.contracts.common.services;

import com.namasoft.common.*;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.edit.NaMaText;
import com.namasoft.common.layout.metadata.*;
import com.namasoft.contracts.common.dtos.*;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;

import jakarta.jws.*;

@WebService(name = "modulews")
public interface ModuleWS
{
	@WebMethod
	ActionResult performAction(@WebParam(name = "request") ActionRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ModuleMetaData getModuleStaticMetaData(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<UIPreferences> fetchPreferences(@WebParam(name = "request") FetchPreferencesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<UIPreferences> savePreferences(@WebParam(name = "request") SavePreferencesRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ValidateFieldResult validateField(@WebParam(name = "validateFieldRequest") ValidateFieldReuest fieldReuest) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTONaMaLayout> saveFile(@WebParam(name = "request") PutRequest<DTONaMaLayout> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<TarnsientCode> createTransientCode(@WebParam(name = "request") TransientCodeRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreensMap> fetchTermConfigScreens(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<EditScreensMap> fetchConfigurationScreens(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NaMaMetaData> fetchTermConfigMetadata(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	PagedDTOTabularResult searchFor(@WebParam(name = "request") SearchRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NaMaMetaData> fetchConfigurationMetadata(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	String oqlToSQL(String oql);

	@WebMethod
	GetResult<FlatObject> readConfiguration(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> runUtil(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse resetServerSettings(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse evictCache(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<NaMaText> runTooltip(@WebParam(name = "request") SendRequest<RunTooltipReq> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse processReplicationMessage(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> listImportanConfigFiles(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	PagedListResult<EntityReferenceData> searchInAliases(@WebParam(name = "request") SearchRequest request) throws NaMaServiceExcepption;
}
