package com.namasoft.contracts.common.services;

import com.namasoft.common.*;
import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.implementationrepo.DTOReportContent;
import com.namasoft.common.layout.metadata.ReportMetadataContainer;
import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.contracts.common.dtos.SuggestionBySQLRequest;
import com.namasoft.contracts.common.dtos.requests.*;
import com.namasoft.contracts.common.dtos.results.*;
import com.namasoft.common.exceptions.NaMaServiceExcepption;

import jakarta.jws.*;

@WebService(name = "reportingws")
public interface ReportingWS
{
	@WebMethod
	DTORunReportResult runReport(@WebParam(name = "request") RunReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	DTORunReportResult fetchReportTaskResult(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	DTORunReportResult runReportWithoutAuth(@WebParam(name = "request") RunReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	DTORunReportResultWithData runReportAndGetResultAsDataHandler(@WebParam(name = "request") RunReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	DTORunReportResult printReport(@WebParam(name = "request") PrintReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<Boolean> isPrintReportPossible(@WebParam(name = "request") PrintReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<ReportMetadataContainer> getReportMetadata(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> putImplRepo(@WebParam(name = "request") SendRequest<DTOReportContent> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOReportContent> getImplRepo(@WebParam(name = "request") ByIdRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ListResult<EntityReferenceData> suggestValuesBySQl(@WebParam(name = "request") SendRequest<SuggestionBySQLRequest> request)
			throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse updateSystemReports(@WebParam(name = "request") ServiceRequest request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse cleanSysReports(@WebParam(name = "request") ServiceRequest serviceRequest) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse importRepository(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFileAttachmentInfo> runInvoiceRetriever(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFileAttachmentInfo> runMobileReport(@WebParam(name = "request") RunReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<StringPair> fetchReportIdAndQuestionsForReportLog(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	ServiceResponse killReport(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> runQueueReportAndReturnTempPrintId(@WebParam(name = "request") SendRequest<String> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFileAttachmentInfo> fetchJasperPrintByTempId(@WebParam(name = "request") SendRequest<DTOFileAttachmentInfo> request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<String> exportUsingUserExportMenu(@WebParam(name = "request") UserExportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFileAttachmentInfo> exportTempPrint(@WebParam(name = "request") RunReportRequest request) throws NaMaServiceExcepption;

	@WebMethod
	GetResult<DTOFileAttachmentInfo> printMobileEntityPDF(@WebParam(name = "request") FindByIDRequest request) throws NaMaServiceExcepption;
}
