package com.namasoft.infra.contractsbase.modules.hr;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.MasterFileDTO;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOJobPosition extends MasterFileDTO implements Serializable
{
	private BigDecimal maxPermissionsHoursPerMonth;
	private BigDecimal maxSinglePermissionHours;
	private EntityReferenceData parent;
	private Integer maxPermissionsPerMonth;
	private String dutiesAndTasks;
	private String fingerPrintException;
	private String fullHierarchyPath;
	private String hierarchyPath;
	public BigDecimal getMaxPermissionsHoursPerMonth()
	{
		return maxPermissionsHoursPerMonth;
	}

	public BigDecimal getMaxSinglePermissionHours()
	{
		return maxSinglePermissionHours;
	}

	public EntityReferenceData getParent()
	{
		return parent;
	}

	public Integer getMaxPermissionsPerMonth()
	{
		return maxPermissionsPerMonth;
	}

	public String getDutiesAndTasks()
	{
		return dutiesAndTasks;
	}

	public String getFingerPrintException()
	{
		return fingerPrintException;
	}

	public String getFullHierarchyPath()
	{
		return fullHierarchyPath;
	}

	public String getHierarchyPath()
	{
		return hierarchyPath;
	}

	public void setDutiesAndTasks(String dutiesAndTasks)
	{
		this.dutiesAndTasks = dutiesAndTasks;
	}

	public void setFingerPrintException(String fingerPrintException)
	{
		this.fingerPrintException = fingerPrintException;
	}

	public void setFullHierarchyPath(String fullHierarchyPath)
	{
		this.fullHierarchyPath = fullHierarchyPath;
	}

	public void setHierarchyPath(String hierarchyPath)
	{
		this.hierarchyPath = hierarchyPath;
	}

	public void setMaxPermissionsHoursPerMonth(BigDecimal maxPermissionsHoursPerMonth)
	{
		this.maxPermissionsHoursPerMonth = maxPermissionsHoursPerMonth;
	}

	public void setMaxPermissionsPerMonth(Integer maxPermissionsPerMonth)
	{
		this.maxPermissionsPerMonth = maxPermissionsPerMonth;
	}

	public void setMaxSinglePermissionHours(BigDecimal maxSinglePermissionHours)
	{
		this.maxSinglePermissionHours = maxSinglePermissionHours;
	}

	public void setParent(EntityReferenceData parent)
	{
		this.parent = parent;
	}

}
