package com.namasoft.modules.commonbasic.contracts.details;

import java.io.Serializable;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.common.utilities.ObjectChecker;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOMenuItem extends GeneratedDTOMenuItem implements Serializable
{
	@Override
	public boolean equals(Object obj)
	{
		if (obj != null && obj instanceof DTOMenuItem)
			return ObjectChecker.areEqual(getId(), ((DTOMenuItem) obj).getId());
		return super.equals(obj);
	}

	@Override
	public int hashCode()
	{
		if (getId() == null)
			return "".hashCode();
		return getId().hashCode();
	}

	public String fetchTargetType()
	{
		if (getTarget() == null)
			return null;
		return getTarget().getType();
	}

	public EntityReferenceData fetchTargetRecord()
	{
		if (getTarget() == null)
			return null;
		return getTarget().getTargetRecord();
	}
}
