package com.namasoft.modules.commonbasic.contracts.requests;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.modules.commonbasic.contracts.requests.inv.DTOReqItemSpecificDimensions;
import com.namasoft.modules.commonbasic.contracts.requests.inv.DTOReqUserQuantity;
import com.namasoft.modules.commonbasic.contracts.valueobjects.DTOGenericDimensions;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOInvTransReqLine implements Serializable
{
	private BigDecimal additionalCost;
	private BigDecimal remaining;
	private BigDecimal totalCost;
	private BigDecimal transferred;
	private BigDecimal unitCost;
	private Boolean inverse;
	private Boolean retunable;
	private DTOGenericDimensions genericDimensions;
	private DTOReqItemSpecificDimensions specificDimensions;
	private DTOReqUserQuantity quantity;
	private Date expiryDate;
	private Date productionDate;
	private Date retestDate;
	private EntityReferenceData documentSubsidiary;
	private EntityReferenceData item;
	private EntityReferenceData lineSubsidiary;
	private Long returnFromSeq;
	private String customerId;
	private String invoiceId;
	private String invoiceType;
	private String originCode;
	private String originId;
	private String originLineId;
	private String originType;
	private String originalSourceLine;
	private String purchasesManId;
	private String remarks;
	private String returnDetails;
	private String salesManId;
	private String supplierId;
	public BigDecimal getAdditionalCost()
	{
		return additionalCost;
	}

	public BigDecimal getRemaining()
	{
		return remaining;
	}

	public BigDecimal getTotalCost()
	{
		return totalCost;
	}

	public BigDecimal getTransferred()
	{
		return transferred;
	}

	public BigDecimal getUnitCost()
	{
		return unitCost;
	}

	public Boolean getInverse()
	{
		return inverse;
	}

	public Boolean getRetunable()
	{
		return retunable;
	}

	public DTOGenericDimensions getGenericDimensions()
	{
		return genericDimensions;
	}

	public DTOReqItemSpecificDimensions getSpecificDimensions()
	{
		return specificDimensions;
	}

	public DTOReqUserQuantity getQuantity()
	{
		return quantity;
	}

	public Date getExpiryDate()
	{
		return expiryDate;
	}

	public Date getProductionDate()
	{
		return productionDate;
	}

	public Date getRetestDate()
	{
		return retestDate;
	}

	public EntityReferenceData getDocumentSubsidiary()
	{
		return documentSubsidiary;
	}

	public EntityReferenceData getItem()
	{
		return item;
	}

	public EntityReferenceData getLineSubsidiary()
	{
		return lineSubsidiary;
	}

	public Long getReturnFromSeq()
	{
		return returnFromSeq;
	}

	public String getCustomerId()
	{
		return customerId;
	}

	public String getInvoiceId()
	{
		return invoiceId;
	}

	public String getInvoiceType()
	{
		return invoiceType;
	}

	public String getOriginCode()
	{
		return originCode;
	}

	public String getOriginId()
	{
		return originId;
	}

	public String getOriginLineId()
	{
		return originLineId;
	}

	public String getOriginType()
	{
		return originType;
	}

	public String getOriginalSourceLine()
	{
		return originalSourceLine;
	}

	public String getPurchasesManId()
	{
		return purchasesManId;
	}

	public String getRemarks()
	{
		return remarks;
	}

	public String getReturnDetails()
	{
		return returnDetails;
	}

	public String getSalesManId()
	{
		return salesManId;
	}

	public String getSupplierId()
	{
		return supplierId;
	}

	public void setAdditionalCost(BigDecimal additionalCost)
	{
		this.additionalCost = additionalCost;
	}

	public void setCustomerId(String customerId)
	{
		this.customerId = customerId;
	}

	public void setDocumentSubsidiary(EntityReferenceData documentSubsidiary)
	{
		this.documentSubsidiary = documentSubsidiary;
	}

	public void setExpiryDate(Date expiryDate)
	{
		this.expiryDate = expiryDate;
	}

	public void setGenericDimensions(DTOGenericDimensions genericDimensions)
	{
		this.genericDimensions = genericDimensions;
	}

	public void setInverse(Boolean inverse)
	{
		this.inverse = inverse;
	}

	public void setInvoiceId(String invoiceId)
	{
		this.invoiceId = invoiceId;
	}

	public void setInvoiceType(String invoiceType)
	{
		this.invoiceType = invoiceType;
	}

	public void setItem(EntityReferenceData item)
	{
		this.item = item;
	}

	public void setLineSubsidiary(EntityReferenceData lineSubsidiary)
	{
		this.lineSubsidiary = lineSubsidiary;
	}

	public void setOriginCode(String originCode)
	{
		this.originCode = originCode;
	}

	public void setOriginId(String originId)
	{
		this.originId = originId;
	}

	public void setOriginLineId(String originLineId)
	{
		this.originLineId = originLineId;
	}

	public void setOriginType(String originType)
	{
		this.originType = originType;
	}

	public void setOriginalSourceLine(String originalSourceLine)
	{
		this.originalSourceLine = originalSourceLine;
	}

	public void setProductionDate(Date productionDate)
	{
		this.productionDate = productionDate;
	}

	public void setPurchasesManId(String purchasesManId)
	{
		this.purchasesManId = purchasesManId;
	}

	public void setQuantity(DTOReqUserQuantity quantity)
	{
		this.quantity = quantity;
	}

	public void setRemaining(BigDecimal remaining)
	{
		this.remaining = remaining;
	}

	public void setRemarks(String remarks)
	{
		this.remarks = remarks;
	}

	public void setRetestDate(Date retestDate)
	{
		this.retestDate = retestDate;
	}

	public void setRetunable(Boolean retunable)
	{
		this.retunable = retunable;
	}

	public void setReturnDetails(String returnDetails)
	{
		this.returnDetails = returnDetails;
	}

	public void setReturnFromSeq(Long returnFromSeq)
	{
		this.returnFromSeq = returnFromSeq;
	}

	public void setSalesManId(String salesManId)
	{
		this.salesManId = salesManId;
	}

	public void setSpecificDimensions(DTOReqItemSpecificDimensions specificDimensions)
	{
		this.specificDimensions = specificDimensions;
	}

	public void setSupplierId(String supplierId)
	{
		this.supplierId = supplierId;
	}

	public void setTotalCost(BigDecimal totalCost)
	{
		this.totalCost = totalCost;
	}

	public void setTransferred(BigDecimal transferred)
	{
		this.transferred = transferred;
	}

	public void setUnitCost(BigDecimal unitCost)
	{
		this.unitCost = unitCost;
	}

}
