package com.namasoft.modules.commonbasic.contracts.valueobjects;

import com.namasoft.common.flatobjects.EntityReferenceData;
import com.namasoft.contracts.common.dtos.DTOLocalEntity;
import com.namasoft.contracts.common.dtos.DTOTransactionMoney;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public abstract class GeneratedDTOCustomerTransEntry extends DTOLocalEntity implements Serializable
{
	private DTOTransactionMoney value;
	private EntityReferenceData customer;
	private EntityReferenceData document;
	private EntityReferenceData relatedAccount;
	private Integer factor;
	public DTOTransactionMoney getValue()
	{
		return value;
	}

	public EntityReferenceData getCustomer()
	{
		return customer;
	}

	public EntityReferenceData getDocument()
	{
		return document;
	}

	public EntityReferenceData getRelatedAccount()
	{
		return relatedAccount;
	}

	public Integer getFactor()
	{
		return factor;
	}

	public void setCustomer(EntityReferenceData customer)
	{
		this.customer = customer;
	}

	public void setDocument(EntityReferenceData document)
	{
		this.document = document;
	}

	public void setFactor(Integer factor)
	{
		this.factor = factor;
	}

	public void setRelatedAccount(EntityReferenceData relatedAccount)
	{
		this.relatedAccount = relatedAccount;
	}

	public void setValue(DTOTransactionMoney value)
	{
		this.value = value;
	}

}
