package com.namasoft.common.constants;

import com.namasoft.common.objects.DTOFileAttachmentInfo;
import com.namasoft.common.utilities.*;
import com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.KeyValuePair;

import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class PlaceTokens
{

	public static final String PREFIX_APPROVALS = "approvals";
	public static final String PREFIX_CONFIGURATION = "configuration";
	public static final String PREFIX_login = "login";
	public static final String PREFIX_notifications = "notifications";
	public static final String PREFIX_userloginhistory = "userloginhistory";
	public static final String PREFIX_sql = "sql";
	public static final String PREFIX_WELCOME = "";
	public static final String PRM_FORM_REPORT_ID = "formReportId";
	public static final String PRM_FIELDS = "fields";
	public static final String PRM_TAB_ID = "tabid";
	public static final String PRM_FOCUS_ON_FIELD = "focusOnField";

	public static String getListPlaceToken(String entityType, Integer page, Integer pageSize, String sortBy)
	{
		return tokenize(PREFIX_LIST, pair(PRM_ENTITY_TYPE, entityType), pair(PRM_PAGE, page), pair(PRM_PAGE_SIZE, pageSize),
				pair(PRM_SORT_BY, sortBy));
	}

	public static String getListPlaceToken(String entityType, String viewName, Integer page, Integer pageSize, String sortBy)
	{
		return tokenize(PREFIX_LIST, pair(PRM_ENTITY_TYPE, entityType), pair(PRM_PAGE, page), pair(PRM_PAGE_SIZE, pageSize),
				pair(PRM_SORT_BY, sortBy), pair(PRM_LIST_VIEW_NAME, viewName));
	}

	public static String tokenize(String prefix, KeyValuePair... keyValuePairs)
	{
		return "#" + prefix + ":" + NaMaKeyValuePairsTokenizer.tokenize(keyValuePairs);
	}

	public static String getEditPlaceToken(String entityType)
	{
		return getEditPlaceToken(entityType, null, ViewMode.NEW);
	}

	public static String getEditPlaceTokenWithMenu(String entityType, String id, String menuCode,String viewName)
	{
		return getEditPlaceToken(entityType, id, ViewMode.EDIT, viewName, menuCode);
	}

	public static String getEditPlaceToken(String entityType, String id, ViewMode view)
	{
		return getEditPlaceToken(entityType, id, view, null, null);
	}

	public static String getEditPlaceToken(String entityType, String id, ViewMode view, String viewName, String menuCode)
	{
		return getEditPlaceToken(entityType, id, view, viewName, menuCode, null);
	}

	public static String getEditPlaceToken(String entityType, String id, ViewMode view, String viewName, String menuCode, Integer versionNumber)
	{
		return tokenize(PREFIX_EDIT, pair(PRM_ENTITY_TYPE, entityType), pair(PRM_ID, id), pair(PRM_VIEW, view), pair(PRM_LIST_VIEW_NAME, viewName),
				pair(PRM_MENU_HASH, menuCode), pair(PRM_VERSION, versionNumber));
	}

	public static String getEditPlaceTokenWithFocusOnFieldAndQRRequester(String entityType, String id, ViewMode view, String focusOnField,
			String quickCreateRequester)
	{
		return tokenize(PREFIX_EDIT, pair(PRM_ENTITY_TYPE, entityType), pair(PRM_ID, id), pair(PRM_VIEW, view),
				pair(PRM_FOCUS_ON_FIELD, focusOnField), pair(PRM_QUICKCREATE_REQUESTER, quickCreateRequester));
	}

	public static String getResetPassword(String resetToken, String resetUserId)
	{
		return tokenize(PREFIX_login, pair(PRM_RESET_TOKEN, resetToken), pair(PRM_RESET_USER, resetUserId));
	}

	public static String linkToFile(String id, DTOFileAttachmentInfo info, String entityType)
	{
		String link = "file.download?fileID=" + id + "&entitytype=" + entityType + "&ischanged=" + info.isUpdated();
		return link;
	}

	public static String linkToFile(String id, String entityType, String fileName)
	{
		String link =
				"file.download?fileID=" + id + "&entitytype=" + entityType + "&ischanged=" + false + "&filename=" + ObjectChecker.toStringOrEmpty(
						fileName);
		return link;
	}
	public static final String PRM_PAGE_SIZE = "pageSize";
	public static final String PRM_PAGE = "page";
	public static final String PRM_SORT_BY = "sort";
	public static final String PRM_ID = "id";
	public static final String PRM_CODE = "code";
	public static final String PRM_CREATED_OBJECT_ID = "createdObjectId";
	public static final String PRM_VIEW = "view";
	public static final String PRM_ENTITY_TYPE = "entity";
	public static final String PREFIX_LIST = "list";
	public static final String PREFIX_EDIT = "edit";
	public static final String PREFIX_Email = "emails";
	public static final String PREFIX_EDIT_FILE = "editfile";
	public static final String PRM_LIST_VIEW_NAME = "lview";
	public static final String PRM_EDIT_VIEW_NAME = "eview";
	public static final String PRM_CRITERIA = "criteria";
	public static final String PRM_QUESTIONS = "questions";
	public static final String PRM_ENTITYID = "eid";
	public static final String PRM_ASCENDING = "asc";
	public static final String PRM_EXTRA_CRITERIA = "extrcrt";
	public static final String PRM_EXTRA_FIELD_FILTER= "extrfltr";
	public static final String PREFIX_EDIT_LAYOUT = "layoutedit";
	public static final String PRM_OWNER_TYPE = "ownertype";
	public static final String PRM_OWNER_ID = "ownerid";
	public static final String PREFIX_ENTITY_CONFIG = "entityconfig";
	public static final String PRM_SHOW_TREE = "tree";
	public static final String PREFIX_LAUNCH_REPORT = "rpt";
	public static final String PREFIX_REPORT_Result = "rptres";
	public static final String PRM_OUTPUT_FORMAT = "frmt";
	public static final String PRM_PRINTING_OPTION = "prntopt";
	public static final String PRM_TEMP_PRINT_ID = "tmpprnt";
	public static final String PRM_PRINTER_NAME = "prntrname";
	public static final String PRM_DOWNLOAD_PURPOSE = "dwnldprp";
	public static final String PREFIX_REPORT_List = "rptlst";
	public static final String PRM_ROOT = "root";
	public static final String PRM_ROOT_TYPE = "rootType";
	public static final String PRM_PAGE_ID = "pgid";
	public static final String PRM_QUICKCREATE = "quick";
	public static final String PRM_LANGUAGE = "lang";
	public static final String PRM_SHOW_IDS = "showids";
	public static final String PRM_NESTING = "nesting";
	public static final String PRM_QUICKCREATE_REQUESTER = "quickreq";
	public static final String PRM_MENU_HASH = "menu";
	public static final String PRM_IS_FORM = "isForm";
	public static final String PRM_LOGOUT = "logout";
	public static final String PRM_VERSION = "version";
	public static final String PRM_REDIRECT = "redirect";
	public static final String PRM_REPLICATION_OPTIONS = "repl";
	public static final String PRM_DEBUG = "dbg";
	public static final String PRM_SERVEROBJECT = "srvrobj";
	public static final String PRM_IMPORT_OBJECTS = "importObjects";
	public static final String PRM_FLOW_ID = "flowid";
	public static final String PRM_FLOW_TARGET_TYPE = "flowtargettype";
	public static final String PRM_FLOW_TARGET_ID = "flowttargetid";
	public static final String PRM_MONIOR_ID = "mntr";
	public static final String PRM_EDIT_TEMPLATE_ID = "tmplt";
	public static final String PRM_DASHBOARDID = "dsh";
	public static final String PRM_RESET_TOKEN = "rsttkn";
	public static final String PRM_RESET_USER = "rstusr";
	public static final String PAIR_SEPERATOR = "/";
	public static final String PARAMETERS_SEPERATOR = "&";
	public static final String FIELDS_SELECTOR_POPUP = "fieldsSelectorPopup";
	public static final String PRM_PENDING_RESPONSE_ID = "pendingResponseId";
	public static final String WIZARD_VIEW = "wizard";
	public static final String LAYOUT_EDITOR_VIEW = "layouteditor";
	public static final String REPORT_WIZARD_EDITOR = "reportWizardEditor";
	public static final String REPORT_EXPRESSION_EDITOR = "reportExpressionEditor";
	public static final String PRM_REPORT_WIZARD_ID = "reportWizardId";
	public static final String PRM_FOR_QUICK_CREATOR_VIEW = "forQuickCreatorView";
	public static final String PRM_FOR_MOBILE_VIEW = "forMobileView";
	public static final String PRM_IS_FROM_REPORTING_ENTITY = "isFromReportingEntity";
	public static final String REPORT_UNION_HANDLING_EDITOR = "reportUnionHandlingEditor";
	public static final String PRM_FIELD_TITLE = "fieldTitle";
	public static final String PRM_DATA_SOURCE_1 = "dataSource1";
	public static final String PRM_DATA_SOURCE_2 = "dataSource2";
	public static final String PRM_DATA_SOURCE_3 = "dataSource3";
	public static final String PRM_DATA_SOURCE_4 = "dataSource4";
	public static final String PRM_DATA_SOURCE_5 = "dataSource5";
	public static final String PRM_SCREEN_TYPE = "screenType";

	public static String downloadURLByRecordId(String id, String itemCode, String entityType, DownloadPurpose purpose, boolean redirect)
	{
		return downloadURL("recordId", id, itemCode, entityType, purpose, redirect, false);
	}

	public static String downloadURL(String id, String entityType, DownloadPurpose purpose, boolean redirect)
	{
		return downloadURL("fileID", id, null, entityType, purpose, redirect, true);
	}

	public static String downloadURL(String idParamName, String id, String itemCode, String entityType, DownloadPurpose purpose, boolean redirect,
			boolean noCache)
	{
		String redirectVal = "&redirect=" + redirect;
		if (redirect)
			redirectVal = "";
		String url = "file.download?" + idParamName + "=" + id + (ObjectChecker.isNotEmptyOrNull(itemCode) ? "&itemCode=" + itemCode : "") + (
				purpose != null ? "&purpose=" + purpose : "") + redirectVal + "&entitytype=" + entityType + "&locale=en" + (noCache ?
				"&nocahce=" + System.currentTimeMillis() :
				"");
		return url;
	}
}
