package com.namasoft.common.criteria;

import java.io.Serializable;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlTransient;

import com.namasoft.common.HasId;

@SuppressWarnings("serial")
@XmlAccessorType(XmlAccessType.PROPERTY)
public class DTOFilledQuestionField implements Serializable, HasId
{
	private String id;
	private String value;
	private transient Object objValue;

	public DTOFilledQuestionField(String id, String value, Object objValue)
	{
		this();
		setId(id);
		setValue(value);
		setObjValue(objValue);
	}

	public DTOFilledQuestionField()
	{
		super();
	}

	public String getId()
	{
		return id;
	}

	public void setId(String id)
	{
		this.id = id;
	}

	public String getValue()
	{
		return value;
	}

	public void setValue(String value)
	{
		this.value = value;
	}

	@XmlTransient
	public Object getObjValue()
	{
		return objValue;
	}

	public void setObjValue(Object objValue)
	{
		this.objValue = objValue;
	}

	@Override
	public String toString()
	{
		return getId() + " = " + getValue();
	}
}
