package com.namasoft.common.fieldids;

import com.namasoft.common.constants.*;

import java.util.*;

abstract public class MobileFieldSuggester
{
	private static final Map<String, List<String>> referenceFieldsMap = new HashMap<>();
	private static final Map<String, List<String>> textFieldsMap = new HashMap<>();

	static
	{
		initializeReferenceFieldsMap();
		initializeTextFieldsMap();
	}

	private static void initializeReferenceFieldsMap()
	{
		referenceFieldsMap.put(HREntities.ElectronicAttendance, List.of("relatedTo"));
		referenceFieldsMap.put(CRMEntities.CRMVisit, List.of("relatedTo"));

		List<String> fromDocField = List.of(NotGeneratedFields.fromDoc);
		referenceFieldsMap.put(SCEntities.SalesReturn, fromDocField);
		referenceFieldsMap.put(SCEntities.DeliveryDocument, fromDocField);
		referenceFieldsMap.put(SCEntities.StockIssue, fromDocField);
		referenceFieldsMap.put(SCEntities.StockReceipt, fromDocField);
		referenceFieldsMap.put(HREntities.WorkStartingDocument, fromDocField);
		referenceFieldsMap.put(SCEntities.StockTransfer, fromDocField);
		referenceFieldsMap.put(SCEntities.StockTransferReq, fromDocField);
		referenceFieldsMap.put(SCEntities.PurchaseInvoice, fromDocField);

		List<String> originDocField = List.of("originDoc");
		referenceFieldsMap.put(SCEntities.SalesOrder, originDocField);
		referenceFieldsMap.put(SCEntities.SalesQuotation, originDocField);
		referenceFieldsMap.put(SCEntities.SalesInvoice, originDocField);
		referenceFieldsMap.put(SCEntities.SalesQuotationRequest, originDocField);

		List<String> threeRefFields = List.of(NotGeneratedFields.ref1, NotGeneratedFields.ref2, NotGeneratedFields.ref3);
		referenceFieldsMap.put(ACCEntities.ElectronicReceiptVoucher, threeRefFields);

		List<String> fifteenRefFields = List.of(NotGeneratedFields.ref1, NotGeneratedFields.ref2, NotGeneratedFields.ref3, NotGeneratedFields.ref4,
				NotGeneratedFields.ref5, NotGeneratedFields.ref6, NotGeneratedFields.ref7, NotGeneratedFields.ref8, NotGeneratedFields.ref9,
				NotGeneratedFields.ref10, NotGeneratedFields.ref11, NotGeneratedFields.ref12, NotGeneratedFields.ref13, NotGeneratedFields.ref14,
				NotGeneratedFields.ref15);
		referenceFieldsMap.put(BSCEntities.FormDoc1, fifteenRefFields);
		referenceFieldsMap.put(BSCEntities.FormDoc2, fifteenRefFields);
		referenceFieldsMap.put(BSCEntities.FormDoc3, fifteenRefFields);
		referenceFieldsMap.put(HREntities.ResidenceRenewReq, List.of(NotGeneratedFields.ref1, NotGeneratedFields.ref2));

		List<String> detailedRemarkFields = List.of("relatedEntity", NotGeneratedFields.ref1, NotGeneratedFields.ref2, NotGeneratedFields.ref3,
				NotGeneratedFields.ref4, NotGeneratedFields.ref5, NotGeneratedFields.ref6, NotGeneratedFields.ref7, NotGeneratedFields.ref8,
				NotGeneratedFields.ref9, NotGeneratedFields.ref10);
		referenceFieldsMap.put(BSCEntities.DetailedRemark, detailedRemarkFields);
		referenceFieldsMap.put(BSCEntities.MeetingRemark, detailedRemarkFields);
	}

	private static void initializeTextFieldsMap()
	{
		textFieldsMap.put("Attendance", List.of("description1"));

		List<String> fiveDescFields = List.of("description1", "description2", "description3", "description4", "description5");
		textFieldsMap.put("SalesOrder", fiveDescFields);
		textFieldsMap.put("SalesDocument", fiveDescFields);
		textFieldsMap.put("SalesReturn", fiveDescFields);
		textFieldsMap.put("StockIssue", fiveDescFields);
		textFieldsMap.put("StockReceipt", fiveDescFields);
		textFieldsMap.put("StockTransfer", fiveDescFields);
		textFieldsMap.put("StockTransferRequest", fiveDescFields);
		textFieldsMap.put("InternalStockTransfer", fiveDescFields);
		textFieldsMap.put("ElectronicStockTaking", fiveDescFields);
		textFieldsMap.put("Vacation", fiveDescFields);
		textFieldsMap.put("DLVDeliveryDocument", fiveDescFields);
		textFieldsMap.put("PurchaseInvoice", fiveDescFields);
		textFieldsMap.put("ElectronicReceipt", fiveDescFields);

		List<String> fifteenDescFields = List.of("description1", "description2", "description3", "description4", "description5", "description6",
				"description7", "description8", "description9", "description10", "description11", "description12", "description13", "description14",
				"description15");
		textFieldsMap.put("FormDoc1", fifteenDescFields);
		textFieldsMap.put("FormDoc2", fifteenDescFields);
		textFieldsMap.put("FormDoc3", fifteenDescFields);
		textFieldsMap.put("ResidenceRenewReq", fiveDescFields);
		textFieldsMap.put("MeetingRemark", fifteenDescFields);
		textFieldsMap.put("DetailedRemark,", fifteenDescFields);
	}

	public static Map<String, List<String>> fetchReffrenceFieldsSuggesterMap()
	{
		return referenceFieldsMap;
	}

	public static Map<String, List<String>> fetchTextFieldsSuggesterMap()
	{
		return textFieldsMap;
	}
}
