package com.namasoft.common.flatobjects;

import com.namasoft.common.Pair;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.util.*;
import java.util.stream.Collectors;

/**
 * to add more cells, use the main function below
 */
@XmlAccessorType(XmlAccessType.FIELD)
public class NamaExcelRow implements EntityReflectionAware
{
	@XmlTransient
	private Object entity;
	private List<String> cells;
	private Integer rowNumber;

	public static boolean validCellName(String s)
	{
		return Collections.binarySearch(SORTED_CELL_NAMES, s.toUpperCase()) >= 0;
	}

	public Object propertyMissing(String name)
	{
		if (validCellName(name))
			return calcCell(name.toUpperCase());
		else
			throw new RuntimeException("No such property: " + name + " for class: " + getClass().getName());
	}

	public NamaExcelRow()
	{
	}

	public static void main(String[] args)
	{
		List<Pair<String, Integer>> pairs = constructNames();
		for (Pair<String, Integer> pair : pairs)
		{
			System.out.println("\tpublic String get" + pair.getX() + "()\n" + "\t{\n" + "\t\treturn calcCell(" + pair.getY() + ");\n" + "\t}");
		}
	}

	private static final List<String> SORTED_CELL_NAMES = constructNames().stream().map(Pair::getX).sorted().collect(Collectors.toList());

	public static List<Pair<String, Integer>> constructNames()
	{
		return constructNames(260);
	}

	public static List<Pair<String, Integer>> constructNames(int max)
	{
		List<Pair<String, Integer>> pairs = new ArrayList<>();
		int index = 0;
		char c1 = 'A';
		for (; index < 26 && index < max; index++)
		{
			pairs.add(new Pair<>("" + c1, index));
			if (c1 == 'Z')
			{
				c1 = 'A';
				index++;
				break;
			}
			c1 += 1;
		}
		char c2 = 'A';

		for (; index < max; index++)
		{
			pairs.add(new Pair<>("" + c1 + c2, index));
			if (c2 == 'Z')
			{
				c1 += 1;
				c2 = 'A';
			}
			else
			{
				c2 += 1;
			}
		}
		return pairs;
	}

	public List<String> getCells()
	{
		return cells;
	}

	public NamaExcelRow(List<String> cells, Integer rowNumber)
	{
		this.cells = cells;
		this.rowNumber = rowNumber;
	}

	public String calcCell(int index)
	{
		return cells == null || cells.size() <= index ? null : cells.get(index);
	}

	public String getA()
	{
		return calcCell(0);
	}

	public String getB()
	{
		return calcCell(1);
	}

	public String getC()
	{
		return calcCell(2);
	}

	public String getD()
	{
		return calcCell(3);
	}

	public String getE()
	{
		return calcCell(4);
	}

	public String getF()
	{
		return calcCell(5);
	}

	public String getG()
	{
		return calcCell(6);
	}

	public String getH()
	{
		return calcCell(7);
	}

	public String getI()
	{
		return calcCell(8);
	}

	public String getJ()
	{
		return calcCell(9);
	}

	public String getK()
	{
		return calcCell(10);
	}

	public String getL()
	{
		return calcCell(11);
	}

	public String getM()
	{
		return calcCell(12);
	}

	public String getN()
	{
		return calcCell(13);
	}

	public String getO()
	{
		return calcCell(14);
	}

	public String getP()
	{
		return calcCell(15);
	}

	public String getQ()
	{
		return calcCell(16);
	}

	public String getR()
	{
		return calcCell(17);
	}

	public String getS()
	{
		return calcCell(18);
	}

	public String getT()
	{
		return calcCell(19);
	}

	public String getU()
	{
		return calcCell(20);
	}

	public String getV()
	{
		return calcCell(21);
	}

	public String getW()
	{
		return calcCell(22);
	}

	public String getX()
	{
		return calcCell(23);
	}

	public String getY()
	{
		return calcCell(24);
	}

	public String getZ()
	{
		return calcCell(25);
	}

	public String getAA()
	{
		return calcCell(26);
	}

	public String getAB()
	{
		return calcCell(27);
	}

	public String getAC()
	{
		return calcCell(28);
	}

	public String getAD()
	{
		return calcCell(29);
	}

	public String getAE()
	{
		return calcCell(30);
	}

	public String getAF()
	{
		return calcCell(31);
	}

	public String getAG()
	{
		return calcCell(32);
	}

	public String getAH()
	{
		return calcCell(33);
	}

	public String getAI()
	{
		return calcCell(34);
	}

	public String getAJ()
	{
		return calcCell(35);
	}

	public String getAK()
	{
		return calcCell(36);
	}

	public String getAL()
	{
		return calcCell(37);
	}

	public String getAM()
	{
		return calcCell(38);
	}

	public String getAN()
	{
		return calcCell(39);
	}

	public String getAO()
	{
		return calcCell(40);
	}

	public String getAP()
	{
		return calcCell(41);
	}

	public String getAQ()
	{
		return calcCell(42);
	}

	public String getAR()
	{
		return calcCell(43);
	}

	public String getAS()
	{
		return calcCell(44);
	}

	public String getAT()
	{
		return calcCell(45);
	}

	public String getAU()
	{
		return calcCell(46);
	}

	public String getAV()
	{
		return calcCell(47);
	}

	public String getAW()
	{
		return calcCell(48);
	}

	public String getAX()
	{
		return calcCell(49);
	}

	public String getAY()
	{
		return calcCell(50);
	}

	public String getAZ()
	{
		return calcCell(51);
	}

	public String getBA()
	{
		return calcCell(52);
	}

	public String getBB()
	{
		return calcCell(53);
	}

	public String getBC()
	{
		return calcCell(54);
	}

	public String getBD()
	{
		return calcCell(55);
	}

	public String getBE()
	{
		return calcCell(56);
	}

	public String getBF()
	{
		return calcCell(57);
	}

	public String getBG()
	{
		return calcCell(58);
	}

	public String getBH()
	{
		return calcCell(59);
	}

	public String getBI()
	{
		return calcCell(60);
	}

	public String getBJ()
	{
		return calcCell(61);
	}

	public String getBK()
	{
		return calcCell(62);
	}

	public String getBL()
	{
		return calcCell(63);
	}

	public String getBM()
	{
		return calcCell(64);
	}

	public String getBN()
	{
		return calcCell(65);
	}

	public String getBO()
	{
		return calcCell(66);
	}

	public String getBP()
	{
		return calcCell(67);
	}

	public String getBQ()
	{
		return calcCell(68);
	}

	public String getBR()
	{
		return calcCell(69);
	}

	public String getBS()
	{
		return calcCell(70);
	}

	public String getBT()
	{
		return calcCell(71);
	}

	public String getBU()
	{
		return calcCell(72);
	}

	public String getBV()
	{
		return calcCell(73);
	}

	public String getBW()
	{
		return calcCell(74);
	}

	public String getBX()
	{
		return calcCell(75);
	}

	public String getBY()
	{
		return calcCell(76);
	}

	public String getBZ()
	{
		return calcCell(77);
	}

	public String getCA()
	{
		return calcCell(78);
	}

	public String getCB()
	{
		return calcCell(79);
	}

	public String getCC()
	{
		return calcCell(80);
	}

	public String getCD()
	{
		return calcCell(81);
	}

	public String getCE()
	{
		return calcCell(82);
	}

	public String getCF()
	{
		return calcCell(83);
	}

	public String getCG()
	{
		return calcCell(84);
	}

	public String getCH()
	{
		return calcCell(85);
	}

	public String getCI()
	{
		return calcCell(86);
	}

	public String getCJ()
	{
		return calcCell(87);
	}

	public String getCK()
	{
		return calcCell(88);
	}

	public String getCL()
	{
		return calcCell(89);
	}

	public String getCM()
	{
		return calcCell(90);
	}

	public String getCN()
	{
		return calcCell(91);
	}

	public String getCO()
	{
		return calcCell(92);
	}

	public String getCP()
	{
		return calcCell(93);
	}

	public String getCQ()
	{
		return calcCell(94);
	}

	public String getCR()
	{
		return calcCell(95);
	}

	public String getCS()
	{
		return calcCell(96);
	}

	public String getCT()
	{
		return calcCell(97);
	}

	public String getCU()
	{
		return calcCell(98);
	}

	public String getCV()
	{
		return calcCell(99);
	}

	public String getCW()
	{
		return calcCell(100);
	}

	public String getCX()
	{
		return calcCell(101);
	}

	public String getCY()
	{
		return calcCell(102);
	}

	public String getCZ()
	{
		return calcCell(103);
	}

	public String getDA()
	{
		return calcCell(104);
	}

	public String getDB()
	{
		return calcCell(105);
	}

	public String getDC()
	{
		return calcCell(106);
	}

	public String getDD()
	{
		return calcCell(107);
	}

	public String getDE()
	{
		return calcCell(108);
	}

	public String getDF()
	{
		return calcCell(109);
	}

	public String getDG()
	{
		return calcCell(110);
	}

	public String getDH()
	{
		return calcCell(111);
	}

	public String getDI()
	{
		return calcCell(112);
	}

	public String getDJ()
	{
		return calcCell(113);
	}

	public String getDK()
	{
		return calcCell(114);
	}

	public String getDL()
	{
		return calcCell(115);
	}

	public String getDM()
	{
		return calcCell(116);
	}

	public String getDN()
	{
		return calcCell(117);
	}

	public String getDO()
	{
		return calcCell(118);
	}

	public String getDP()
	{
		return calcCell(119);
	}

	public String getDQ()
	{
		return calcCell(120);
	}

	public String getDR()
	{
		return calcCell(121);
	}

	public String getDS()
	{
		return calcCell(122);
	}

	public String getDT()
	{
		return calcCell(123);
	}

	public String getDU()
	{
		return calcCell(124);
	}

	public String getDV()
	{
		return calcCell(125);
	}

	public String getDW()
	{
		return calcCell(126);
	}

	public String getDX()
	{
		return calcCell(127);
	}

	public String getDY()
	{
		return calcCell(128);
	}

	public String getDZ()
	{
		return calcCell(129);
	}

	public String getEA()
	{
		return calcCell(130);
	}

	public String getEB()
	{
		return calcCell(131);
	}

	public String getEC()
	{
		return calcCell(132);
	}

	public String getED()
	{
		return calcCell(133);
	}

	public String getEE()
	{
		return calcCell(134);
	}

	public String getEF()
	{
		return calcCell(135);
	}

	public String getEG()
	{
		return calcCell(136);
	}

	public String getEH()
	{
		return calcCell(137);
	}

	public String getEI()
	{
		return calcCell(138);
	}

	public String getEJ()
	{
		return calcCell(139);
	}

	public String getEK()
	{
		return calcCell(140);
	}

	public String getEL()
	{
		return calcCell(141);
	}

	public String getEM()
	{
		return calcCell(142);
	}

	public String getEN()
	{
		return calcCell(143);
	}

	public String getEO()
	{
		return calcCell(144);
	}

	public String getEP()
	{
		return calcCell(145);
	}

	public String getEQ()
	{
		return calcCell(146);
	}

	public String getER()
	{
		return calcCell(147);
	}

	public String getES()
	{
		return calcCell(148);
	}

	public String getET()
	{
		return calcCell(149);
	}

	public String getEU()
	{
		return calcCell(150);
	}

	public String getEV()
	{
		return calcCell(151);
	}

	public String getEW()
	{
		return calcCell(152);
	}

	public String getEX()
	{
		return calcCell(153);
	}

	public String getEY()
	{
		return calcCell(154);
	}

	public String getEZ()
	{
		return calcCell(155);
	}

	public String getFA()
	{
		return calcCell(156);
	}

	public String getFB()
	{
		return calcCell(157);
	}

	public String getFC()
	{
		return calcCell(158);
	}

	public String getFD()
	{
		return calcCell(159);
	}

	public String getFE()
	{
		return calcCell(160);
	}

	public String getFF()
	{
		return calcCell(161);
	}

	public String getFG()
	{
		return calcCell(162);
	}

	public String getFH()
	{
		return calcCell(163);
	}

	public String getFI()
	{
		return calcCell(164);
	}

	public String getFJ()
	{
		return calcCell(165);
	}

	public String getFK()
	{
		return calcCell(166);
	}

	public String getFL()
	{
		return calcCell(167);
	}

	public String getFM()
	{
		return calcCell(168);
	}

	public String getFN()
	{
		return calcCell(169);
	}

	public String getFO()
	{
		return calcCell(170);
	}

	public String getFP()
	{
		return calcCell(171);
	}

	public String getFQ()
	{
		return calcCell(172);
	}

	public String getFR()
	{
		return calcCell(173);
	}

	public String getFS()
	{
		return calcCell(174);
	}

	public String getFT()
	{
		return calcCell(175);
	}

	public String getFU()
	{
		return calcCell(176);
	}

	public String getFV()
	{
		return calcCell(177);
	}

	public String getFW()
	{
		return calcCell(178);
	}

	public String getFX()
	{
		return calcCell(179);
	}

	public String getFY()
	{
		return calcCell(180);
	}

	public String getFZ()
	{
		return calcCell(181);
	}

	public String getGA()
	{
		return calcCell(182);
	}

	public String getGB()
	{
		return calcCell(183);
	}

	public String getGC()
	{
		return calcCell(184);
	}

	public String getGD()
	{
		return calcCell(185);
	}

	public String getGE()
	{
		return calcCell(186);
	}

	public String getGF()
	{
		return calcCell(187);
	}

	public String getGG()
	{
		return calcCell(188);
	}

	public String getGH()
	{
		return calcCell(189);
	}

	public String getGI()
	{
		return calcCell(190);
	}

	public String getGJ()
	{
		return calcCell(191);
	}

	public String getGK()
	{
		return calcCell(192);
	}

	public String getGL()
	{
		return calcCell(193);
	}

	public String getGM()
	{
		return calcCell(194);
	}

	public String getGN()
	{
		return calcCell(195);
	}

	public String getGO()
	{
		return calcCell(196);
	}

	public String getGP()
	{
		return calcCell(197);
	}

	public String getGQ()
	{
		return calcCell(198);
	}

	public String getGR()
	{
		return calcCell(199);
	}

	public String getGS()
	{
		return calcCell(200);
	}

	public String getGT()
	{
		return calcCell(201);
	}

	public String getGU()
	{
		return calcCell(202);
	}

	public String getGV()
	{
		return calcCell(203);
	}

	public String getGW()
	{
		return calcCell(204);
	}

	public String getGX()
	{
		return calcCell(205);
	}

	public String getGY()
	{
		return calcCell(206);
	}

	public String getGZ()
	{
		return calcCell(207);
	}

	public String getHA()
	{
		return calcCell(208);
	}

	public String getHB()
	{
		return calcCell(209);
	}

	public String getHC()
	{
		return calcCell(210);
	}

	public String getHD()
	{
		return calcCell(211);
	}

	public String getHE()
	{
		return calcCell(212);
	}

	public String getHF()
	{
		return calcCell(213);
	}

	public String getHG()
	{
		return calcCell(214);
	}

	public String getHH()
	{
		return calcCell(215);
	}

	public String getHI()
	{
		return calcCell(216);
	}

	public String getHJ()
	{
		return calcCell(217);
	}

	public String getHK()
	{
		return calcCell(218);
	}

	public String getHL()
	{
		return calcCell(219);
	}

	public String getHM()
	{
		return calcCell(220);
	}

	public String getHN()
	{
		return calcCell(221);
	}

	public String getHO()
	{
		return calcCell(222);
	}

	public String getHP()
	{
		return calcCell(223);
	}

	public String getHQ()
	{
		return calcCell(224);
	}

	public String getHR()
	{
		return calcCell(225);
	}

	public String getHS()
	{
		return calcCell(226);
	}

	public String getHT()
	{
		return calcCell(227);
	}

	public String getHU()
	{
		return calcCell(228);
	}

	public String getHV()
	{
		return calcCell(229);
	}

	public String getHW()
	{
		return calcCell(230);
	}

	public String getHX()
	{
		return calcCell(231);
	}

	public String getHY()
	{
		return calcCell(232);
	}

	public String getHZ()
	{
		return calcCell(233);
	}

	public String getIA()
	{
		return calcCell(234);
	}

	public String getIB()
	{
		return calcCell(235);
	}

	public String getIC()
	{
		return calcCell(236);
	}

	public String getID()
	{
		return calcCell(237);
	}

	public String getIE()
	{
		return calcCell(238);
	}

	public String getIF()
	{
		return calcCell(239);
	}

	public String getIG()
	{
		return calcCell(240);
	}

	public String getIH()
	{
		return calcCell(241);
	}

	public String getII()
	{
		return calcCell(242);
	}

	public String getIJ()
	{
		return calcCell(243);
	}

	public String getIK()
	{
		return calcCell(244);
	}

	public String getIL()
	{
		return calcCell(245);
	}

	public String getIM()
	{
		return calcCell(246);
	}

	public String getIN()
	{
		return calcCell(247);
	}

	public String getIO()
	{
		return calcCell(248);
	}

	public String getIP()
	{
		return calcCell(249);
	}

	public String getIQ()
	{
		return calcCell(250);
	}

	public String getIR()
	{
		return calcCell(251);
	}

	public String getIS()
	{
		return calcCell(252);
	}

	public String getIT()
	{
		return calcCell(253);
	}

	public String getIU()
	{
		return calcCell(254);
	}

	public String getIV()
	{
		return calcCell(255);
	}

	public String getIW()
	{
		return calcCell(256);
	}

	public String getIX()
	{
		return calcCell(257);
	}

	public String getIY()
	{
		return calcCell(258);
	}

	public String getIZ()
	{
		return calcCell(259);
	}

	public void setEntity(Object entity)
	{
		this.entity = entity;
	}

	public Object getEntity()
	{
		return entity;
	}

	public String calcCell(String cell)
	{
		cell = cell.trim();
		if (ObjectChecker.isEmptyOrNull(cell))
			return null;
		int index = 0;
		for (int i = cell.length() - 1; i >= 0; i--)
		{
			index += (i * 26) + (cell.charAt(i) - 'A');
		}
		return calcCell(index);
	}

	public boolean containsNonEmptyCells()
	{
		return getCells() != null && getCells().stream().anyMatch(ObjectChecker::isNotEmptyOrNull);
	}

	@Override
	public Object fetchFieldValue(String fieldId)
	{
		return calcCell(fieldId);
	}

	public Integer getRowNumber()
	{
		return rowNumber;
	}

	public void setRowNumber(Integer rowNumber)
	{
		this.rowNumber = rowNumber;
	}
}
