package com.namasoft.common.flatobjects.http;

import com.namasoft.common.utilities.*;

import jakarta.xml.bind.annotation.*;

import java.util.*;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class HttpRequest implements HttpRequestBodyPartHandler
{
	private List<NameValue> headers = new ArrayList<>();
	private List<NameValue> parameters = new ArrayList<>();
	private List<NameValue> jsonBody = new ArrayList<>();
	private String body;
	private String url;
	private String method = "POST";
	private String contentType;
	private String charSet;
	private String description1;
	private String description2;
	private String relatedToId1;
	private String relatedToId2;

	public List<NameValue> getHeaders()
	{
		return headers;
	}

	public void setHeaders(List<NameValue> headers)
	{
		this.headers = headers;
	}

	public List<NameValue> getParameters()
	{
		return parameters;
	}

	public void setParameters(List<NameValue> parameters)
	{
		this.parameters = parameters;
	}

	public List<NameValue> getJsonBody()
	{
		return jsonBody;
	}

	public void setJsonBody(List<NameValue> jsonBody)
	{
		this.jsonBody = jsonBody;
	}

	public String getBody()
	{
		return body;
	}

	public void setBody(String body)
	{
		this.body = body;
	}

	public String getUrl()
	{
		return url;
	}

	public void setUrl(String url)
	{
		this.url = url;
	}

	public HttpRequest url(String url)
	{
		this.url = url;
		return this;
	}

	public String getMethod()
	{
		if (ObjectChecker.isEmptyOrNull(method))
			method = "POST";
		return method;
	}

	public void setMethod(String method)
	{
		this.method = method;
	}

	public HttpRequest post()
	{
		setMethod("POST");
		return this;
	}

	public HttpRequest get()
	{
		setMethod("GET");
		return this;
	}

	public String getContentType()
	{
		return contentType;
	}

	public void setContentType(String contentType)
	{
		this.contentType = contentType;
	}

	public HttpRequest contentTypeJsonUTF8()
	{
		return contentType("application/json").charSetUTF8();
	}

	public HttpRequest contentTypeX_WWW_FORM_URLENCODED()
	{
		return contentType("application/x-www-form-urlencoded").charSetUTF8();
	}

	public HttpRequest contentType(String contentType)
	{
		this.contentType = contentType;
		return this;
	}

	public String getCharSet()
	{
		return charSet;
	}

	public void setCharSet(String charSet)
	{
		this.charSet = charSet;
	}

	public HttpRequest charSet(String charSet)
	{
		this.charSet = charSet;
		return this;
	}

	public HttpRequest charSetUTF8()
	{
		setCharSet("utf-8");
		return this;
	}

	public HttpRequest addHeader(String name, String value)
	{
		if (getHeaders() == null)
			setHeaders(new ArrayList<>());
		getHeaders().add(new NameValue(name, value));
		return this;
	}

	public void addBodyPart(String name, Object value)
	{
		if (getJsonBody() == null)
			setJsonBody(new ArrayList<>());
		getJsonBody().add(new NameValue(name, value));
	}

	@Override
	public void setLastBodyPartValue(String value)
	{
		CollectionsUtility.getLast(getJsonBody()).setValue(value);
	}

	public HttpRequest addParameter(String name, String value)
	{
		if (getParameters() == null)
			setParameters(new ArrayList<>());
		getParameters().add(new NameValue(name, value));
		return this;
	}

	public String getDescription1()
	{
		return description1;
	}

	public void setDescription1(String description1)
	{
		this.description1 = description1;
	}

	public String getDescription2()
	{
		return description2;
	}

	public void setDescription2(String description2)
	{
		this.description2 = description2;
	}

	public String getRelatedToId1()
	{
		return relatedToId1;
	}

	public void setRelatedToId1(String relatedToId1)
	{
		this.relatedToId1 = relatedToId1;
	}

	public String getRelatedToId2()
	{
		return relatedToId2;
	}

	public void setRelatedToId2(String relatedToId2)
	{
		this.relatedToId2 = relatedToId2;
	}

	public HttpRequest addJsonBodyPart(String name, String value)
	{
		if (getJsonBody() == null)
			setJsonBody(new ArrayList<>());
		getJsonBody().add(new NameValue(name, value));
		return this;
	}

	public HttpRequest body(String body)
	{
		setBody(body);
		return this;
	}

	public HttpRequest addHeaders(Map<String, String> headers)
	{
		if (headers == null)
			return this;
		for (Map.Entry<String, String> entry : headers.entrySet())
		{
			addHeader(entry.getKey(), entry.getValue());
		}
		return this;
	}
}
