package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.constants.*;
import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.urlutils.ObjectToURLUtil;
import com.namasoft.common.utilities.*;

import java.util.*;

import static com.namasoft.common.constants.PlaceTokens.*;
import static com.namasoft.common.utilities.NaMaKeyValuePairsTokenizer.pair;

public class CreatorNode extends RenderNode
{
	private final String nodeContent;
	private String entityTypeExpression;
	private String titleExpression;
	private String menuCode;
	private String targetExpression;
	private String viewCode;

	@Override
	public List<String> collectVariables()
	{
		return Arrays.asList(entityTypeExpression, titleExpression, menuCode, targetExpression, viewCode);
	}

	CreatorNode(String nodeContent)
	{
		this.nodeContent = nodeContent;
		List<String> parts = StringUtils.csvLineToList(StringUtils.getInnerString(nodeContent, "(", ")"));
		this.entityTypeExpression = parts.get(0);
		for (int i = parts.size() - 1; i >= 0; i--)
		{
			if (parts.get(i).trim().startsWith("menu="))
			{
				menuCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("view="))
			{
				viewCode = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("title="))
			{
				titleExpression = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().startsWith("entity="))
			{
				entityTypeExpression = StringUtils.substringAfter(parts.remove(i), "=");
			}
			else if (parts.get(i).trim().toLowerCase().startsWith("newwindow="))
			{
				targetExpression = StringUtils.substringAfter(parts.remove(i), "=");
			}
		}
		if (parts.size() > 1)
			this.titleExpression = parts.get(1);
	}

	@Override
	public boolean isLeafNode()
	{
		return false;
	}

	@Override
	public String describe()
	{
		return "{" + nodeContent + "}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		StringBuilder innerBuilder = new StringBuilder();
		renderSubNodes(innerBuilder, helper, currentLineNumber);
		String compressedFields = innerBuilder.toString();
		compressedFields = CommonConstants.BASE64_PREFIX + ObjectToURLUtil.encode(compressedFields);
		String entityType = renderer.evalConstantOrVar(entityTypeExpression, helper, currentLineNumber, insideCreator(), this);
		String guiServerURL = renderer.calcGUIURL();
		String resolvedMenu = null;
		if (ObjectChecker.isNotEmptyOrNull(menuCode))
			resolvedMenu = renderer.evalConstantOrVar(menuCode, helper, currentLineNumber, insideCreator(), this);
		String resolvedViewCode = null;
		if (ObjectChecker.isNotEmptyOrNull(viewCode))
			resolvedViewCode = renderer.evalConstantOrVar(viewCode, helper, currentLineNumber, insideCreator(), this);

		String targetWindow = "";

		if (ObjectChecker.isNotEmptyOrNull(targetExpression))
		{
			String target = renderer.evalConstantOrVar(targetExpression, helper, currentLineNumber, insideCreator(), this);
			if (ObjectChecker.isNotEmptyOrNull(target))
			{
				if (ObjectChecker.areEqual(target, "popup"))
					targetWindow = target;
				else
					targetWindow = " target='_blank' ";
			}

		}

		String tokens = PlaceTokens.tokenize(PREFIX_EDIT, pair(PRM_ENTITY_TYPE, entityType), pair(PRM_FIELDS, compressedFields),
				pair(PRM_VIEW, ViewMode.NEW), pair(PRM_MENU_HASH, resolvedMenu), pair(PRM_LIST_VIEW_NAME, resolvedViewCode));
		String link = guiServerURL + tokens;
		String title = renderer.evalConstantOrVar(titleExpression, helper, currentLineNumber, insideCreator(), this);
		if (renderer.isDirectLink())
		{
			if (ObjectChecker.isNotEmptyOrNull(targetWindow))
			{
				if (targetWindow.equals("popup"))
				{
					builder.append(CommonConstants.OPEN_LINK_IN_POPUP);
					link = tokens;
				}
				else
				{
					builder.append(CommonConstants.OPEN_LINK_IN_NEW_WINDOW);
				}
			}
			builder.append(link);
		}
		else
		{
			builder.append("<a href='").append(link).append("' ").append(targetWindow).append(">").append(title).append("</a>");
		}
	}

	@Override
	public boolean isMyEnder(String nodeContent)
	{
		return ObjectChecker.areEqual(nodeContent, "endcreator");
	}
}
