package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;
import com.namasoft.common.flatobjects.http.HttpRequestBodyPartHandler;
import com.namasoft.common.utilities.StringUtils;

import java.util.TreeMap;

//todo consider creating body part array class later, it should have multiple bodypartvalue nodes, and each one adds an object to the array
public class HttpRequestBodyPartNode extends AbsHttpRequestNode
{
	private final String expression;

	public HttpRequestBodyPartNode(String nodeContent)
	{
		super(nodeContent);
		this.expression = StringUtils.getInnerString(nodeContent, "(", ")");
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		TreeMap<Object, Object> value = new TreeMap<>();
		renderer.currentBodyPartHandler().addBodyPart(renderer.evalConstantOrVar(expression, helper, currentLineNumber, false, this), value);
		HttpRequestBodyPartHandler lastHandler = renderer.currentBodyPartHandler;
		renderer.currentBodyPartHandler = new HttpRequestBodyPartHandler()
		{
			private String lastKey;

			@Override
			public void addBodyPart(String name, Object val)
			{
				value.put(lastKey = name, val);
			}

			@Override
			public void setLastBodyPartValue(String val)
			{
				value.put(lastKey, val);
			}
		};
		renderSubNodes(builder, helper, currentLineNumber);
		renderer.currentBodyPartHandler = lastHandler;
	}

	@Override
	protected String enderStr()
	{
		return "endbodypart";
	}
}
