package com.namasoft.common.flatobjects.tempo;

import com.namasoft.common.flatobjects.RendererPropertyResolver;

public class ShortLinksNode extends RenderNode
{
	public ShortLinksNode(ComplexRenderer renderer)
	{
		this.renderer = renderer;
		renderer.shortLinks(true);
	}

	@Override
	public boolean isLeafNode()
	{
		return true;
	}

	@Override
	public String describe()
	{
		return "{shortlinks}";
	}

	@Override
	public void render(StringBuilder builder, RendererPropertyResolver helper, int currentLineNumber)
	{
		renderer.shortLinks(true);
	}
}
