package com.namasoft.common.layout.edit;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.layout.metadata.CustomRepInfo;
import com.namasoft.common.utilities.*;

@SuppressWarnings("serial")
public class CustomizedGUIActionInfo extends NaMaDTO implements NamaObject
{
	private String notificationId;
	private String entityFlowId;
	private String guiPostActionsId;
	private String performActionAsField;
	private String bulkEditId;
	private String urlTemplate;
	private String query;
	private CustomRepInfo reportInfo;
	private String securityID;

	public String getNotificationId()
	{
		return notificationId;
	}

	public void setNotificationId(String notificationId)
	{
		this.notificationId = notificationId;
	}

	public String getGuiPostActionsId()
	{
		return guiPostActionsId;
	}

	public void setGuiPostActionsId(String guiPostActionsId)
	{
		this.guiPostActionsId = guiPostActionsId;
	}

	public String getEntityFlowId()
	{
		return entityFlowId;
	}

	public void setEntityFlowId(String entityFlowId)
	{
		this.entityFlowId = entityFlowId;
	}

	public String getUrlTemplate()
	{
		return urlTemplate;
	}

	public void setUrlTemplate(String urlTemplate)
	{
		this.urlTemplate = urlTemplate;
	}

	public String getQuery()
	{
		return query;
	}

	public void setQuery(String query)
	{
		this.query = query;
	}

	public CustomRepInfo getReportInfo()
	{
		return reportInfo;
	}

	public void setReportInfo(CustomRepInfo reportInfo)
	{
		this.reportInfo = reportInfo;
	}

	public String getPerformActionAsField()
	{
		return performActionAsField;
	}

	public void setPerformActionAsField(String performActionAsField)
	{
		this.performActionAsField = performActionAsField;
	}

	public String fetchReportDefinitionId()
	{
		return getReportInfo() == null ? null : getReportInfo().getReportId();
	}

	public String getSecurityID()
	{
		return securityID;
	}

	public void setSecurityID(String securityID)
	{
		this.securityID = securityID;
	}

	@Override
	public boolean isEmpty()
	{
		return ObjectChecker.areAllEmptyOrNull(getUrlTemplate(), getQuery(), getNotificationId(), getEntityFlowId(), getGuiPostActionsId(),
				fetchReportDefinitionId(), getBulkEditId());
	}

	public String getBulkEditId()
	{
		return bulkEditId;
	}

	public void setBulkEditId(String bulkEditId)
	{
		this.bulkEditId = bulkEditId;
	}
}
