package com.namasoft.common.layout.list;

import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.io.Serializable;

@XmlAccessorType(XmlAccessType.PROPERTY)
public class CmnFieldFilteringParams implements Serializable
{
	private Boolean ignoreLoginAnalysisSet;
	private Boolean ignoreLoginBranch;
	private Boolean ignoreLoginDepartment;
	private Boolean ignoreLoginLegalEntity;
	private Boolean ignoreLoginSector;
	private Boolean preventFilterByAnalysisSet;
	private Boolean preventFilterByBranch;
	private Boolean preventFilterByDept;
	private Boolean preventFilterByLegalEntity;
	private Boolean preventFilterBySector;

	public Boolean getIgnoreLoginAnalysisSet()
	{
		return ignoreLoginAnalysisSet;
	}

	public void setIgnoreLoginAnalysisSet(Boolean ignoreLoginAnalysisSet)
	{
		this.ignoreLoginAnalysisSet = ignoreLoginAnalysisSet;
	}

	public Boolean getIgnoreLoginBranch()
	{
		return ignoreLoginBranch;
	}

	public void setIgnoreLoginBranch(Boolean ignoreLoginBranch)
	{
		this.ignoreLoginBranch = ignoreLoginBranch;
	}

	public Boolean getIgnoreLoginDepartment()
	{
		return ignoreLoginDepartment;
	}

	public void setIgnoreLoginDepartment(Boolean ignoreLoginDepartment)
	{
		this.ignoreLoginDepartment = ignoreLoginDepartment;
	}

	public Boolean getIgnoreLoginLegalEntity()
	{
		return ignoreLoginLegalEntity;
	}

	public void setIgnoreLoginLegalEntity(Boolean ignoreLoginLegalEntity)
	{
		this.ignoreLoginLegalEntity = ignoreLoginLegalEntity;
	}

	public Boolean getIgnoreLoginSector()
	{
		return ignoreLoginSector;
	}

	public void setIgnoreLoginSector(Boolean ignoreLoginSector)
	{
		this.ignoreLoginSector = ignoreLoginSector;
	}

	public Boolean getPreventFilterByAnalysisSet()
	{
		return preventFilterByAnalysisSet;
	}

	public void setPreventFilterByAnalysisSet(Boolean preventFilterByAnalysisSet)
	{
		this.preventFilterByAnalysisSet = preventFilterByAnalysisSet;
	}

	public Boolean getPreventFilterByBranch()
	{
		return preventFilterByBranch;
	}

	public void setPreventFilterByBranch(Boolean preventFilterByBranch)
	{
		this.preventFilterByBranch = preventFilterByBranch;
	}

	public Boolean getPreventFilterByDept()
	{
		return preventFilterByDept;
	}

	public void setPreventFilterByDept(Boolean preventFilterByDept)
	{
		this.preventFilterByDept = preventFilterByDept;
	}

	public Boolean getPreventFilterByLegalEntity()
	{
		return preventFilterByLegalEntity;
	}

	public void setPreventFilterByLegalEntity(Boolean preventFilterByLegalEntity)
	{
		this.preventFilterByLegalEntity = preventFilterByLegalEntity;
	}

	public Boolean getPreventFilterBySector()
	{
		return preventFilterBySector;
	}

	public void setPreventFilterBySector(Boolean preventFilterBySector)
	{
		this.preventFilterBySector = preventFilterBySector;
	}

	public CmnFieldFilteringParams toNullIfNothingIsTrue()
	{
		if (ObjectChecker.areAllFalseOrNull(getIgnoreLoginAnalysisSet(), getIgnoreLoginBranch(), getIgnoreLoginDepartment(),
				getIgnoreLoginLegalEntity(), getIgnoreLoginSector(), getPreventFilterByLegalEntity(), getPreventFilterBySector(),
				getPreventFilterByAnalysisSet(), getPreventFilterByBranch(), getPreventFilterByDept()))
			return null;
		return this;
	}
}
