package com.namasoft.common.layout.metadata;

import com.namasoft.common.NaMaDTO;
import com.namasoft.common.fieldids.Fields;
import com.namasoft.common.flatobjects.*;
import com.namasoft.common.layout.list.ListOfString;
import com.namasoft.common.utilities.ObjectChecker;
import jakarta.xml.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;

@SuppressWarnings("serial")
@XmlRootElement
@XmlAccessorType(XmlAccessType.PROPERTY)
public class CustomGUIComponentsMetadata extends NaMaDTO
{
	private Boolean aiModuleAvailable;
	private Date calendarYearStart;
	private Date calendarYearEnd;
	private String globalConfigReportsViewingFormat;
	private String customerName;
	private String subRelease;
	private String subServer;
	private FlatObject fiscalPeriod;
	private CustomReportsMetadata customReportsMetadata;
	private TooltipMetadata tooltipMetadata;
	private HashMap<String, ReviseSettings> entitiesReviseLevelsMap;
	private Integer defaultReviseLevel;
	private Integer defaultDisplayDecimalPlaces;
	private Boolean allowTextWrapInGrids;
	private Boolean allowTextWrapInListViews;
	private Boolean doNotUseTodayAndYesterdayForDates;
	private Boolean allowFillingDisabledFieldsWithCreators;
	private FieldsAllowedValuesMetadata fieldsAllowedValues;
	private CustomizedFieldsInfo customizedFieldsInfo;
	private EntitiesMainFileInfo entityMainFileInfo;
	private Boolean useReviseDocumentForAllEntities;
	private String codeSearchOperator;
	private String name1SearchOperator;
	private String name2SearchOperator;
	private Boolean showSearchInForTopPanel;
	private Boolean mustSelectEntityInSearchInBeforeSearchOnServer;
	private Boolean fixMenuAsSideBar;
	private Map<String, TemplateTriggerMetaDataList> templeteMap;
	private Map<String, CmnGUIPostAction> guiPostActions;
	private Map<String, CmnGUIPostAction> manualGuiPostActions = new HashMap<>();
	private Map<String, CmnGUIPostAction> customQuickCreator;
	private Map<String, CmnGUIPostAction> suggestionProviders;
	private DTOCmnFontInfo fontInfo;
	private String costOutType;
	private Boolean allowDisablingCodeFieldWithSecurity;
	private String notificationContent;
	private Boolean hideSelectColumnInSelectorPopup;
	private Boolean hideCountColumnInSelectorPopup;
	private Boolean newGUIEnabled;
	private String googleMapsApiKey;
	private Boolean alwaysUseTextAreaInSerialPopup;
	private Boolean useDetailedGridsInMobile;
	private String defaultCScanTwainProfileNo;
	private String defaultScannerApp;
	private String tooltipPosition;
	private Map<String, CmnExtraReferenceSearchSettingList> extraReferenceSearchSetting;
	private Map<String, ListOfString> entitiesExtraCodes;
	private Boolean pinToolTip;

	public CustomGUIComponentsMetadata()
	{
	}

	public CustomGUIComponentsMetadata(CustomReportsMetadata customReportsMetadata, TooltipMetadata tooltipMetadata,
			HashMap<String, ReviseSettings> entitiesReviseCounts, Integer defaultReviseLevel, Boolean allowTextWrapInGrids,
			FieldsAllowedValuesMetadata fieldsAllowedValues, CustomizedFieldsInfo customizedFieldsInfo, EntitiesMainFileInfo entityMainFileInfo,
			Boolean useReviseDocumentForAllEntities, Map<String, TemplateTriggerMetaDataList> templeteMap, DTOCmnFontInfo fontInfo,
			String codeSearchOperator, String name1SearchOperator, String name2SearchOperator, String costOutType, FlatObject fiscalPeriod,
			Integer defaultDisplayDecimalPlaces, String notificationContent, Map<String, CmnGUIPostAction> guiPostActions,
			Boolean hideSelectColumnInSelectorPopup, Boolean hideCountColumnInSelectorPopup,
			Boolean useDetailedGridsInMobile)
	{
		this.useDetailedGridsInMobile = useDetailedGridsInMobile;
		this.customReportsMetadata = customReportsMetadata;
		this.tooltipMetadata = tooltipMetadata;
		this.defaultReviseLevel = defaultReviseLevel;
		this.entitiesReviseLevelsMap = entitiesReviseCounts;
		this.allowTextWrapInGrids = allowTextWrapInGrids;
		this.fieldsAllowedValues = fieldsAllowedValues;
		this.customizedFieldsInfo = customizedFieldsInfo;
		this.entityMainFileInfo = entityMainFileInfo;
		this.useReviseDocumentForAllEntities = useReviseDocumentForAllEntities;
		this.templeteMap = templeteMap;
		this.fontInfo = fontInfo;
		this.codeSearchOperator = codeSearchOperator;
		this.name1SearchOperator = name1SearchOperator;
		this.name2SearchOperator = name2SearchOperator;
		this.costOutType = costOutType;
		this.fiscalPeriod = fiscalPeriod;
		this.defaultDisplayDecimalPlaces = defaultDisplayDecimalPlaces;
		this.notificationContent = notificationContent;
		this.guiPostActions = guiPostActions;
		this.hideSelectColumnInSelectorPopup = hideSelectColumnInSelectorPopup;
		this.hideCountColumnInSelectorPopup = hideCountColumnInSelectorPopup;
	}

	public Boolean getUseDetailedGridsInMobile()
	{
		return useDetailedGridsInMobile;
	}

	public void setUseDetailedGridsInMobile(Boolean useDetailedGridsInMobile)
	{
		this.useDetailedGridsInMobile = useDetailedGridsInMobile;
	}

	public Boolean getNewGUIEnabled()
	{
		return newGUIEnabled;
	}

	public void setNewGUIEnabled(Boolean newGUIEnabled)
	{
		this.newGUIEnabled = newGUIEnabled;
	}

	public String getGoogleMapsApiKey()
	{
		return googleMapsApiKey;
	}

	public void setGoogleMapsApiKey(String googleMapsApiKey)
	{
		this.googleMapsApiKey = googleMapsApiKey;
	}

	public Map<String, TemplateTriggerMetaDataList> getTempleteMap()
	{
		return templeteMap;
	}

	public void setTempleteMap(Map<String, TemplateTriggerMetaDataList> templeteMap)
	{
		this.templeteMap = templeteMap;
	}

	public CustomReportsMetadata getCustomReportsMetadata()
	{
		return customReportsMetadata;
	}

	public void setCustomReportsMetadata(CustomReportsMetadata customReportsMetadata)
	{
		this.customReportsMetadata = customReportsMetadata;
	}

	public TooltipMetadata getTooltipMetadata()
	{
		return tooltipMetadata;
	}

	public void setTooltipMetadata(TooltipMetadata tooltipMetadata)
	{
		this.tooltipMetadata = tooltipMetadata;
	}

	public HashMap<String, ReviseSettings> getEntitiesReviseLevelsMap()
	{
		return entitiesReviseLevelsMap;
	}

	public void setEntitiesReviseLevelsMap(HashMap<String, ReviseSettings> entitiesReviseCounts)
	{
		this.entitiesReviseLevelsMap = entitiesReviseCounts;
	}

	public Integer getDefaultReviseLevel()
	{
		return defaultReviseLevel;
	}

	public void setDefaultReviseLevel(Integer defaultReviseCount)
	{
		this.defaultReviseLevel = defaultReviseCount;
	}

	public Boolean getAllowTextWrapInGrids()
	{
		return allowTextWrapInGrids;
	}

	public void setAllowTextWrapInGrids(Boolean allowTextWrapInGrids)
	{
		this.allowTextWrapInGrids = allowTextWrapInGrids;
	}

	public Boolean getAllowTextWrapInListViews()
	{
		return allowTextWrapInListViews;
	}

	public void setAllowTextWrapInListViews(Boolean allowTextWrapInListViews)
	{
		this.allowTextWrapInListViews = allowTextWrapInListViews;
	}

	public FieldsAllowedValuesMetadata getFieldsAllowedValues()
	{
		return fieldsAllowedValues;
	}

	public void setFieldsAllowedValues(FieldsAllowedValuesMetadata fieldsAllowedValues)
	{
		this.fieldsAllowedValues = fieldsAllowedValues;
	}

	public String getCodeSearchOperator()
	{
		return codeSearchOperator;
	}

	public void setCodeSearchOperator(String codeSearchOperator)
	{
		this.codeSearchOperator = codeSearchOperator;
	}

	public String getName1SearchOperator()
	{
		return name1SearchOperator;
	}

	public void setName1SearchOperator(String name1SearchOperator)
	{
		this.name1SearchOperator = name1SearchOperator;
	}

	public String getName2SearchOperator()
	{
		return name2SearchOperator;
	}

	public void setName2SearchOperator(String name2SearchOperator)
	{
		this.name2SearchOperator = name2SearchOperator;
	}

	public String getCostOutType()
	{
		return costOutType;
	}

	public void setCostOutType(String costOutType)
	{
		this.costOutType = costOutType;
	}

	public Boolean getHideSelectColumnInSelectorPopup()
	{
		return hideSelectColumnInSelectorPopup;
	}

	public void setHideSelectColumnInSelectorPopup(Boolean hideSelectColumnInSelectorPopup)
	{
		this.hideSelectColumnInSelectorPopup = hideSelectColumnInSelectorPopup;
	}

	public Boolean getHideCountColumnInSelectorPopup()
	{
		return hideCountColumnInSelectorPopup;
	}

	public void setHideCountColumnInSelectorPopup(Boolean hideCountColumnInSelectorPopup)
	{
		this.hideCountColumnInSelectorPopup = hideCountColumnInSelectorPopup;
	}

	public ReviseSettings findEntityMaxReviseCount(String entityType)
	{
		ReviseSettings entityMaxReviseCount = new ReviseSettings(getDefaultReviseLevel(), getUseReviseDocumentForAllEntities());
		if (ObjectChecker.isNotEmptyOrNull(getEntitiesReviseLevelsMap())
				&& ObjectChecker.isNotEmptyOrNull(getEntitiesReviseLevelsMap().get(entityType)))
			entityMaxReviseCount = getEntitiesReviseLevelsMap().get(entityType);
		else if (ObjectChecker.isNotEmptyOrNull(getDefaultReviseLevel()) && getDefaultReviseLevel() > 0)
			entityMaxReviseCount = new ReviseSettings(getDefaultReviseLevel(), getUseReviseDocumentForAllEntities());
		return entityMaxReviseCount;
	}

	public CustomizedFieldsInfo getCustomizedFieldsInfo()
	{
		if (customizedFieldsInfo == null)
			customizedFieldsInfo = new CustomizedFieldsInfo();
		return customizedFieldsInfo;
	}

	public void setCustomizedFieldsInfo(CustomizedFieldsInfo customizedFieldsInfo)
	{
		this.customizedFieldsInfo = customizedFieldsInfo;
	}

	public EntitiesMainFileInfo getEntityMainFileInfo()
	{
		if (entityMainFileInfo == null)
			entityMainFileInfo = new EntitiesMainFileInfo();
		return entityMainFileInfo;
	}

	public void setEntityMainFileInfo(EntitiesMainFileInfo entityMainFileInfo)
	{
		this.entityMainFileInfo = entityMainFileInfo;
	}

	public Boolean getUseReviseDocumentForAllEntities()
	{
		return useReviseDocumentForAllEntities;
	}

	public void setUseReviseDocumentForAllEntities(Boolean useReviseDocumentForAllEntities)
	{
		this.useReviseDocumentForAllEntities = useReviseDocumentForAllEntities;
	}

	public String findFieldExtraFilter(String entityType, String sourceFieldId, String filteredType)
	{
		if (getCustomizedFieldsInfo().getFieldFiltersMap().containsKey(entityType + "." + sourceFieldId + "." + filteredType))
			return getCustomizedFieldsInfo().getFieldFiltersMap().get(entityType + "." + sourceFieldId);
		if (getCustomizedFieldsInfo().getFieldFiltersMap().containsKey(entityType + "." + sourceFieldId))
			return getCustomizedFieldsInfo().getFieldFiltersMap().get(entityType + "." + sourceFieldId);
		if (getCustomizedFieldsInfo().getFieldFiltersMap().containsKey(sourceFieldId))
			return getCustomizedFieldsInfo().getFieldFiltersMap().get(sourceFieldId);
		return null;
	}

	public String calcFieldValueTriggeredTemplate(String entityType, String sourceFieldId, Object value)
	{
		if (ObjectChecker.isEmptyOrNull(value) || ObjectChecker.isEmptyOrNull(getTempleteMap()))
			return null;
		TemplateTriggerMetaDataList templateTriggerList = getTempleteMap().get(entityType + "." + sourceFieldId);
		if (templateTriggerList == null)
			return null;
		for (TemplateTriggerMetaData template : templateTriggerList.getTemplates())
		{
			if (isTemplateMatchValue(value, template))
				return template.getTemplateId();
		}
		return null;
	}

	private boolean isTemplateMatchValue(Object value, TemplateTriggerMetaData templateComposite)
	{
		if (value instanceof BigDecimal)
			return ObjectChecker.areEqual(value.toString(), templateComposite.getNumericValue().toString());
		else if (value instanceof String)
			return ObjectChecker.areEqual(value, templateComposite.getTextValue());
		else if (value instanceof Date)
			return ObjectChecker.areEqual(FieldTypesUtils.toString(FieldType.Date, value),
					FieldTypesUtils.toString(FieldType.Date, templateComposite.getDateValue()));
		else if (value instanceof EntityReferenceData)
			return ObjectChecker.areEqual(value, templateComposite.getRefValue());
		else if (value instanceof FlatObject && templateComposite.getRefValue() != null)
			return ObjectChecker.areEqual(Fields.id((FlatObject) value), templateComposite.getRefValue().getId());
		return false;
	}

	public DTOCmnFontInfo getFontInfo()
	{
		return fontInfo;
	}

	public void setFontInfo(DTOCmnFontInfo fontInfo)
	{
		this.fontInfo = fontInfo;
	}

	public Boolean getAllowDisablingCodeFieldWithSecurity()
	{
		return allowDisablingCodeFieldWithSecurity;
	}

	public void setAllowDisablingCodeFieldWithSecurity(Boolean allowDisablingCodeFieldWithSecurity)
	{
		this.allowDisablingCodeFieldWithSecurity = allowDisablingCodeFieldWithSecurity;
	}

	public FlatObject getFiscalPeriod()
	{
		return fiscalPeriod;
	}

	public void setFiscalPeriod(FlatObject fiscalPeriod)
	{
		this.fiscalPeriod = fiscalPeriod;
	}

	public Integer getDefaultDisplayDecimalPlaces()
	{
		return defaultDisplayDecimalPlaces;
	}

	public void setDefaultDisplayDecimalPlaces(Integer defaultDisplayDecimalPlaces)
	{
		this.defaultDisplayDecimalPlaces = defaultDisplayDecimalPlaces;
	}

	public Map<String, CmnGUIPostAction> getGuiPostActions()
	{
		return guiPostActions;
	}

	public void setGuiPostActions(Map<String, CmnGUIPostAction> guiPostActions)
	{
		this.guiPostActions = guiPostActions;
	}

	public Map<String, CmnGUIPostAction> getManualGuiPostActions()
	{
		return manualGuiPostActions;
	}

	public void setManualGuiPostActions(Map<String, CmnGUIPostAction> manualGuiPostActions)
	{
		this.manualGuiPostActions = manualGuiPostActions;
	}

	public String getNotificationContent()
	{
		return notificationContent;
	}

	public void setNotificationContent(String notificationContent)
	{
		this.notificationContent = notificationContent;
	}

	public Map<String, CmnGUIPostAction> getCustomQuickCreator()
	{
		if (customQuickCreator == null)
			customQuickCreator = new HashMap<>();
		return customQuickCreator;
	}

	public void setCustomQuickCreator(Map<String, CmnGUIPostAction> customQuickCreator)
	{
		this.customQuickCreator = customQuickCreator;
	}

	public Map<String, CmnGUIPostAction> getSuggestionProviders()
	{
		if (suggestionProviders == null)
			suggestionProviders = new HashMap<>();
		return suggestionProviders;
	}

	public void setSuggestionProviders(Map<String, CmnGUIPostAction> suggestionProviders)
	{
		this.suggestionProviders = suggestionProviders;
	}

	public String getCustomerName()
	{
		return customerName;
	}

	public void setCustomerName(String customerName)
	{
		this.customerName = customerName;
	}

	public String getSubServer()
	{
		return subServer;
	}

	public void setSubServer(String subServer)
	{
		this.subServer = subServer;
	}

	public void setAlwaysUseTextAreaInSerialPopup(Boolean alwaysUseTextAreaInSerialPopup)
	{
		this.alwaysUseTextAreaInSerialPopup = alwaysUseTextAreaInSerialPopup;
	}

	public Boolean getAlwaysUseTextAreaInSerialPopup()
	{
		return alwaysUseTextAreaInSerialPopup;
	}

	public Map<String, CmnExtraReferenceSearchSettingList> getExtraReferenceSearchSetting()
	{
		return extraReferenceSearchSetting;
	}

	public void setExtraReferenceSearchSetting(Map<String, CmnExtraReferenceSearchSettingList> extraReferenceSearchSetting)
	{
		this.extraReferenceSearchSetting = extraReferenceSearchSetting;
	}

	public Boolean getShowSearchInForTopPanel()
	{
		return showSearchInForTopPanel;
	}

	public void setShowSearchInForTopPanel(Boolean showSearchInForTopPanel)
	{
		this.showSearchInForTopPanel = showSearchInForTopPanel;
	}

	public Boolean getMustSelectEntityInSearchInBeforeSearchOnServer()
	{
		return mustSelectEntityInSearchInBeforeSearchOnServer;
	}

	public void setMustSelectEntityInSearchInBeforeSearchOnServer(Boolean mustSelectEntityInSearchInBeforeSearchOnServer)
	{
		this.mustSelectEntityInSearchInBeforeSearchOnServer = mustSelectEntityInSearchInBeforeSearchOnServer;
	}

	public Boolean getFixMenuAsSideBar()
	{
		return fixMenuAsSideBar;
	}

	public void setFixMenuAsSideBar(Boolean fixMenuAsSideBar)
	{
		this.fixMenuAsSideBar = fixMenuAsSideBar;
	}

	public Boolean getDoNotUseTodayAndYesterdayForDates()
	{
		return doNotUseTodayAndYesterdayForDates;
	}

	public void setDoNotUseTodayAndYesterdayForDates(Boolean doNotUseTodayAndYesterdayForDates)
	{
		this.doNotUseTodayAndYesterdayForDates = doNotUseTodayAndYesterdayForDates;
	}

	public String getSubRelease()
	{
		return subRelease;
	}

	public void setSubRelease(String subRelease)
	{
		this.subRelease = subRelease;
	}

	public Date getCalendarYearStart()
	{
		return calendarYearStart;
	}

	public void setCalendarYearStart(Date calendarYearStart)
	{
		this.calendarYearStart = calendarYearStart;
	}

	public Date getCalendarYearEnd()
	{
		return calendarYearEnd;
	}

	public void setCalendarYearEnd(Date calendarYearEnd)
	{
		this.calendarYearEnd = calendarYearEnd;
	}

	public String getGlobalConfigReportsViewingFormat()
	{
		return globalConfigReportsViewingFormat;
	}

	public void setGlobalConfigReportsViewingFormat(String globalConfigReportsViewingFormat)
	{
		this.globalConfigReportsViewingFormat = globalConfigReportsViewingFormat;
	}

	public Boolean getAllowFillingDisabledFieldsWithCreators()
	{
		return allowFillingDisabledFieldsWithCreators;
	}

	public void setAllowFillingDisabledFieldsWithCreators(Boolean allowFillingDisabledFieldsWithCreators)
	{
		this.allowFillingDisabledFieldsWithCreators = allowFillingDisabledFieldsWithCreators;
	}

	public String getDefaultCScanTwainProfileNo()
	{
		return defaultCScanTwainProfileNo;
	}

	public void setDefaultCScanTwainProfileNo(String defaultCScanTwainProfileNo)
	{
		this.defaultCScanTwainProfileNo = defaultCScanTwainProfileNo;
	}

	public String getDefaultScannerApp()
	{
		return defaultScannerApp;
	}

	public void setDefaultScannerApp(String defaultScannerApp)
	{
		this.defaultScannerApp = defaultScannerApp;
	}

	public String getTooltipPosition()
	{
		return tooltipPosition;
	}

	public void setTooltipPosition(String tooltipPosition)
	{
		this.tooltipPosition = tooltipPosition;
	}

	public Map<String, ListOfString> getEntitiesExtraCodes()
	{
		return entitiesExtraCodes;
	}

	public void setEntitiesExtraCodes(Map<String, ListOfString> entitiesExtraCodes)
	{
		this.entitiesExtraCodes = entitiesExtraCodes;
	}

	public Boolean getAiModuleAvailable()
	{
		return aiModuleAvailable;
	}

	public void setAiModuleAvailable(Boolean aiModuleAvailable)
	{
		this.aiModuleAvailable = aiModuleAvailable;
	}

	public Boolean getPinToolTip()
	{
		return pinToolTip;
	}

	public void setPinToolTip(Boolean pinToolTip)
	{
		this.pinToolTip = pinToolTip;
	}
}
